/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class SynchronizedQueue<T>
implements Cloneable,
Queue<T> {
    private final Queue<T> list = new LinkedList<T>();
    private final int size;

    public SynchronizedQueue() {
        this.size = -1;
    }

    public SynchronizedQueue(int n2) {
        this.size = n2;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized boolean add(T t2) {
        return this.list.add(t2);
    }

    @Override
    public synchronized boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> collection) {
        return this.list.addAll(collection);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized String toString() {
        return this.list.toString();
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SynchronizedQueue)object;
        return this.list.equals(((SynchronizedQueue)object).list);
    }

    @Override
    public synchronized T peek() {
        return this.list.peek();
    }

    @Override
    public synchronized T element() {
        return this.list.element();
    }

    @Override
    public synchronized T poll() {
        return this.list.poll();
    }

    @Override
    public synchronized T remove() {
        return this.list.remove();
    }

    @Override
    public synchronized boolean offer(T t2) {
        if (this.size >= 0 && this.list.size() + 1 > this.size) {
            return false;
        }
        return this.list.offer(t2);
    }

    public synchronized Object clone() {
        SynchronizedQueue<T> synchronizedQueue = new SynchronizedQueue<T>(this.size);
        synchronizedQueue.addAll((Collection<T>)this.list);
        return synchronizedQueue;
    }

    @Override
    public synchronized Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public synchronized <R> R[] toArray(R[] RArray) {
        return this.list.toArray(RArray);
    }
}

