/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class SubscriptionList
implements Subscription {
    private List<Subscription> subscriptions;
    private volatile boolean unsubscribed;

    public SubscriptionList() {
    }

    public SubscriptionList(Subscription ... subscriptionArray) {
        this.subscriptions = new LinkedList<Subscription>(Arrays.asList(subscriptionArray));
    }

    public SubscriptionList(Subscription subscription) {
        this.subscriptions = new LinkedList<Subscription>();
        this.subscriptions.add(subscription);
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Subscription subscription) {
        if (subscription.isUnsubscribed()) {
            return;
        }
        if (!this.unsubscribed) {
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                if (!this.unsubscribed) {
                    List<Subscription> list = this.subscriptions;
                    if (list == null) {
                        this.subscriptions = list = new LinkedList<Subscription>();
                    }
                    list.add(subscription);
                    return;
                }
            }
        }
        subscription.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Subscription subscription) {
        if (!this.unsubscribed) {
            boolean bl;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                List<Subscription> list = this.subscriptions;
                if (this.unsubscribed || list == null) {
                    return;
                }
                bl = list.remove(subscription);
            }
            if (bl) {
                subscription.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unsubscribe() {
        if (!this.unsubscribed) {
            List<Subscription> list;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                list = this.subscriptions;
                this.subscriptions = null;
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    private static void unsubscribeFromAll(Collection<Subscription> object) {
        if (object == null) {
            return;
        }
        ArrayList<Throwable> arrayList = null;
        object = object.iterator();
        while (object.hasNext()) {
            Subscription subscription = (Subscription)object.next();
            try {
                subscription.unsubscribe();
            }
            catch (Throwable throwable) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Throwable>();
                }
                arrayList.add(throwable);
            }
        }
        Exceptions.throwIfAny(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        if (!this.unsubscribed) {
            List<Subscription> list;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                list = this.subscriptions;
                this.subscriptions = null;
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasSubscriptions() {
        if (!this.unsubscribed) {
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                return !this.unsubscribed && this.subscriptions != null && !this.subscriptions.isEmpty();
            }
        }
        return false;
    }
}

