/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.ObjectPool;
import com.zoyi.rx.internal.util.PlatformDependent;
import com.zoyi.rx.internal.util.RxRingBuffer$1;
import com.zoyi.rx.internal.util.RxRingBuffer$2;
import com.zoyi.rx.internal.util.SynchronizedQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;

public class RxRingBuffer
implements Subscription {
    private static final NotificationLite<Object> ON;
    private Queue<Object> queue;
    private final int size;
    private final ObjectPool<Queue<Object>> pool;
    public volatile Object terminalState;
    public static final int SIZE;
    public static final ObjectPool<Queue<Object>> SPSC_POOL;
    public static final ObjectPool<Queue<Object>> SPMC_POOL;

    public static RxRingBuffer getSpscInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(SPSC_POOL, SIZE);
        }
        return new RxRingBuffer();
    }

    public static RxRingBuffer getSpmcInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(SPMC_POOL, SIZE);
        }
        return new RxRingBuffer();
    }

    private RxRingBuffer(Queue<Object> queue, int n2) {
        this.queue = queue;
        this.pool = null;
        this.size = n2;
    }

    private RxRingBuffer(ObjectPool<Queue<Object>> objectPool, int n2) {
        this.pool = objectPool;
        this.queue = objectPool.borrowObject();
        this.size = n2;
    }

    public synchronized void release() {
        Queue<Object> queue = this.queue;
        ObjectPool<Queue<Object>> objectPool = this.pool;
        if (objectPool != null && queue != null) {
            queue.clear();
            this.queue = null;
            objectPool.returnObject(queue);
        }
    }

    @Override
    public void unsubscribe() {
        this.release();
    }

    RxRingBuffer() {
        this(new SynchronizedQueue<Object>(SIZE), SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Object object) throws MissingBackpressureException {
        boolean bl = false;
        boolean bl2 = false;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> queue = this.queue;
            if (queue != null) {
                bl2 = !queue.offer(ON.next(object));
            } else {
                bl = true;
            }
        }
        if (bl) {
            throw new IllegalStateException("This instance has been unsubscribed and the queue is no longer usable.");
        }
        if (bl2) {
            throw new MissingBackpressureException();
        }
    }

    public void onCompleted() {
        if (this.terminalState == null) {
            this.terminalState = ON.completed();
        }
    }

    public void onError(Throwable throwable) {
        if (this.terminalState == null) {
            this.terminalState = ON.error(throwable);
        }
    }

    public int available() {
        return this.size - this.count();
    }

    public int capacity() {
        return this.size;
    }

    public int count() {
        Queue<Object> queue = this.queue;
        if (queue == null) {
            return 0;
        }
        return queue.size();
    }

    public boolean isEmpty() {
        Queue<Object> queue = this.queue;
        if (queue == null) {
            return true;
        }
        return queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object object;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> queue = this.queue;
            if (queue == null) {
                return null;
            }
            object = queue.poll();
            Object object2 = this.terminalState;
            if (object == null && object2 != null && queue.peek() == null) {
                object = object2;
                this.terminalState = null;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object object;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> queue = this.queue;
            if (queue == null) {
                return null;
            }
            object = queue.peek();
            Object object2 = this.terminalState;
            if (object == null && object2 != null && queue.peek() == null) {
                object = object2;
            }
        }
        return object;
    }

    public boolean isCompleted(Object object) {
        return ON.isCompleted(object);
    }

    public boolean isError(Object object) {
        return ON.isError(object);
    }

    public Object getValue(Object object) {
        return ON.getValue(object);
    }

    public boolean accept(Object object, Observer observer) {
        return ON.accept(observer, object);
    }

    public Throwable asError(Object object) {
        return ON.getError(object);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.queue == null;
    }

    static {
        String string;
        ON = NotificationLite.instance();
        int n2 = 128;
        if (PlatformDependent.isAndroid()) {
            n2 = 16;
        }
        if ((string = System.getProperty("com.zoyi.rx.ring-buffer.size")) != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Failed to set 'com.zoyi.rx.buffer.size' with value " + string + " => " + numberFormatException.getMessage());
            }
        }
        SIZE = n2;
        SPSC_POOL = new RxRingBuffer$1();
        SPMC_POOL = new RxRingBuffer$2();
    }
}

