/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.internal.util.PlatformDependent$1;
import java.security.AccessController;

public final class PlatformDependent {
    public static final int ANDROID_API_VERSION_IS_NOT_ANDROID = 0;
    private static final int ANDROID_API_VERSION = PlatformDependent.resolveAndroidApiVersion();
    private static final boolean IS_ANDROID = ANDROID_API_VERSION != 0;

    private PlatformDependent() {
        throw new IllegalStateException("No instances!");
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static int getAndroidApiVersion() {
        return ANDROID_API_VERSION;
    }

    private static int resolveAndroidApiVersion() {
        try {
            return (Integer)Class.forName("android.os.Build$VERSION", true, PlatformDependent.getSystemClassLoader()).getField("SDK_INT").get(null);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent$1());
    }
}

