/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.util.IndexedRingBuffer$1;
import com.zoyi.rx.internal.util.IndexedRingBuffer$ElementSection;
import com.zoyi.rx.internal.util.IndexedRingBuffer$IndexSection;
import com.zoyi.rx.internal.util.ObjectPool;
import com.zoyi.rx.internal.util.PlatformDependent;
import java.util.concurrent.atomic.AtomicInteger;

public final class IndexedRingBuffer<E>
implements Subscription {
    private final IndexedRingBuffer$ElementSection<E> elements = new IndexedRingBuffer$ElementSection();
    private final IndexedRingBuffer$IndexSection removed = new IndexedRingBuffer$IndexSection();
    final AtomicInteger index = new AtomicInteger();
    final AtomicInteger removedIndex = new AtomicInteger();
    private static final ObjectPool<IndexedRingBuffer<?>> POOL;
    static final int SIZE;

    public static <T> IndexedRingBuffer<T> getInstance() {
        return POOL.borrowObject();
    }

    public final void releaseToPool() {
        int n2 = this.index.get();
        int n3 = 0;
        IndexedRingBuffer$ElementSection<E> indexedRingBuffer$ElementSection = this.elements;
        block0: while (indexedRingBuffer$ElementSection != null) {
            int n4 = 0;
            while (n4 < SIZE) {
                if (n3 >= n2) break block0;
                indexedRingBuffer$ElementSection.array.set(n4, null);
                ++n4;
                ++n3;
            }
            indexedRingBuffer$ElementSection = indexedRingBuffer$ElementSection.next.get();
        }
        this.index.set(0);
        this.removedIndex.set(0);
        POOL.returnObject(this);
    }

    @Override
    public final void unsubscribe() {
        this.releaseToPool();
    }

    IndexedRingBuffer() {
    }

    public final int add(E e2) {
        int n2 = this.getIndexForAdd();
        if (n2 < SIZE) {
            this.elements.array.set(n2, e2);
            return n2;
        }
        int n3 = n2 % SIZE;
        this.getElementSection((int)n2).array.set(n3, e2);
        return n2;
    }

    public final E remove(int n2) {
        E e2;
        if (n2 < SIZE) {
            e2 = this.elements.array.getAndSet(n2, null);
        } else {
            int n3 = n2 % SIZE;
            e2 = this.getElementSection((int)n2).array.getAndSet(n3, null);
        }
        this.pushRemovedIndex(n2);
        return e2;
    }

    private IndexedRingBuffer$IndexSection getIndexSection(int n2) {
        if (n2 < SIZE) {
            return this.removed;
        }
        n2 /= SIZE;
        IndexedRingBuffer$IndexSection indexedRingBuffer$IndexSection = this.removed;
        for (int i2 = 0; i2 < n2; ++i2) {
            indexedRingBuffer$IndexSection = indexedRingBuffer$IndexSection.getNext();
        }
        return indexedRingBuffer$IndexSection;
    }

    private IndexedRingBuffer$ElementSection<E> getElementSection(int n2) {
        if (n2 < SIZE) {
            return this.elements;
        }
        n2 /= SIZE;
        IndexedRingBuffer$ElementSection<E> indexedRingBuffer$ElementSection = this.elements;
        for (int i2 = 0; i2 < n2; ++i2) {
            indexedRingBuffer$ElementSection = indexedRingBuffer$ElementSection.getNext();
        }
        return indexedRingBuffer$ElementSection;
    }

    private synchronized int getIndexForAdd() {
        int n2 = this.getIndexFromPreviouslyRemoved();
        if (n2 >= 0) {
            if (n2 < SIZE) {
                n2 = this.removed.getAndSet(n2, -1);
            } else {
                int n3 = n2 % SIZE;
                n2 = this.getIndexSection(n2).getAndSet(n3, -1);
            }
            if (n2 == this.index.get()) {
                this.index.getAndIncrement();
            }
        } else {
            n2 = this.index.getAndIncrement();
        }
        return n2;
    }

    private synchronized int getIndexFromPreviouslyRemoved() {
        int n2;
        while ((n2 = this.removedIndex.get()) > 0) {
            if (!this.removedIndex.compareAndSet(n2, n2 - 1)) continue;
            return n2 - 1;
        }
        return -1;
    }

    private synchronized void pushRemovedIndex(int n2) {
        int n3 = this.removedIndex.getAndIncrement();
        if (n3 < SIZE) {
            this.removed.set(n3, n2);
            return;
        }
        int n4 = n3 % SIZE;
        this.getIndexSection(n3).set(n4, n2);
    }

    @Override
    public final boolean isUnsubscribed() {
        return false;
    }

    public final int forEach(Func1<? super E, Boolean> func1) {
        return this.forEach(func1, 0);
    }

    public final int forEach(Func1<? super E, Boolean> func1, int n2) {
        int n3 = this.forEach(func1, n2, this.index.get());
        if (n2 > 0 && n3 == this.index.get()) {
            n3 = this.forEach(func1, 0, n2);
        } else if (n3 == this.index.get()) {
            n3 = 0;
        }
        return n3;
    }

    private int forEach(Func1<? super E, Boolean> func1, int n2, int n3) {
        int n4 = this.index.get();
        int n5 = n2;
        IndexedRingBuffer$ElementSection<E> indexedRingBuffer$ElementSection = this.elements;
        if (n2 >= SIZE) {
            indexedRingBuffer$ElementSection = this.getElementSection(n2);
            n2 %= SIZE;
        }
        block0: while (indexedRingBuffer$ElementSection != null) {
            int n6 = n2;
            while (n6 < SIZE) {
                if (n5 >= n4 || n5 >= n3) break block0;
                Object e2 = indexedRingBuffer$ElementSection.array.get(n6);
                if (e2 != null) {
                    n2 = n5;
                    boolean bl = func1.call(e2);
                    if (!bl) {
                        return n2;
                    }
                }
                ++n6;
                ++n5;
            }
            indexedRingBuffer$ElementSection = indexedRingBuffer$ElementSection.next.get();
            n2 = 0;
        }
        return n5;
    }

    static {
        String string;
        POOL = new IndexedRingBuffer$1();
        int n2 = 128;
        if (PlatformDependent.isAndroid()) {
            n2 = 8;
        }
        if ((string = System.getProperty("com.zoyi.rx.indexed-ring-buffer.size")) != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Failed to set 'com.zoyi.rx.indexed-ring-buffer.size' with value " + string + " => " + numberFormatException.getMessage());
            }
        }
        SIZE = n2;
    }
}

