/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.exceptions.CompositeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

public enum ExceptionsUtils {

    private static final Throwable TERMINATED = new Throwable("Terminated");

    public static boolean addThrowable(AtomicReference<Throwable> atomicReference, Throwable throwable) {
        Serializable serializable;
        Throwable throwable2;
        do {
            if ((throwable2 = atomicReference.get()) == TERMINATED) {
                return false;
            }
            if (throwable2 == null) {
                serializable = throwable;
                continue;
            }
            if (throwable2 instanceof CompositeException) {
                serializable = new ArrayList<Throwable>(((CompositeException)throwable2).getExceptions());
                serializable.add((Throwable)throwable);
                serializable = new CompositeException((Collection<? extends Throwable>)((Object)serializable));
                continue;
            }
            serializable = new CompositeException(throwable2, throwable);
        } while (!atomicReference.compareAndSet(throwable2, (Throwable)serializable));
        return true;
    }

    public static Throwable terminate(AtomicReference<Throwable> atomicReference) {
        Throwable throwable = atomicReference.get();
        if (throwable != TERMINATED) {
            throwable = atomicReference.getAndSet(TERMINATED);
        }
        return throwable;
    }

    public static boolean isTerminated(AtomicReference<Throwable> atomicReference) {
        return ExceptionsUtils.isTerminated(atomicReference.get());
    }

    public static boolean isTerminated(Throwable throwable) {
        return throwable == TERMINATED;
    }
}

