/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.OnErrorNotImplementedException;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.schedulers.ScheduledAction$FutureCompleter;
import com.zoyi.rx.internal.schedulers.ScheduledAction$Remover;
import com.zoyi.rx.internal.schedulers.ScheduledAction$Remover2;
import com.zoyi.rx.internal.util.SubscriptionList;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public final class ScheduledAction
extends AtomicReference<Thread>
implements Subscription,
Runnable {
    private static final long serialVersionUID = -3962399486978279857L;
    final SubscriptionList cancel;
    final Action0 action;

    public ScheduledAction(Action0 action0) {
        this.action = action0;
        this.cancel = new SubscriptionList();
    }

    public ScheduledAction(Action0 action0, CompositeSubscription compositeSubscription) {
        this.action = action0;
        this.cancel = new SubscriptionList((Subscription)new ScheduledAction$Remover(this, compositeSubscription));
    }

    public ScheduledAction(Action0 action0, SubscriptionList subscriptionList) {
        this.action = action0;
        this.cancel = new SubscriptionList((Subscription)new ScheduledAction$Remover2(this, subscriptionList));
    }

    @Override
    public final void run() {
        try {
            this.lazySet(Thread.currentThread());
            this.action.call();
            return;
        }
        catch (OnErrorNotImplementedException onErrorNotImplementedException) {
            this.signalError(new IllegalStateException("Exception thrown on Scheduler.Worker thread. Add `onError` handling.", onErrorNotImplementedException));
            return;
        }
        catch (Throwable throwable) {
            this.signalError(new IllegalStateException("Fatal Exception thrown on Scheduler.Worker thread.", throwable));
            return;
        }
        finally {
            this.unsubscribe();
        }
    }

    final void signalError(Throwable throwable) {
        RxJavaHooks.onError(throwable);
        Thread thread = Thread.currentThread();
        thread.getUncaughtExceptionHandler().uncaughtException(thread, throwable);
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.cancel.isUnsubscribed();
    }

    @Override
    public final void unsubscribe() {
        if (!this.cancel.isUnsubscribed()) {
            this.cancel.unsubscribe();
        }
    }

    public final void add(Subscription subscription) {
        this.cancel.add(subscription);
    }

    public final void add(Future<?> future) {
        this.cancel.add(new ScheduledAction$FutureCompleter(this, future));
    }

    public final void addParent(CompositeSubscription compositeSubscription) {
        this.cancel.add(new ScheduledAction$Remover(this, compositeSubscription));
    }

    public final void addParent(SubscriptionList subscriptionList) {
        this.cancel.add(new ScheduledAction$Remover2(this, subscriptionList));
    }
}

