/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.schedulers.NewThreadWorker$1;
import com.zoyi.rx.internal.schedulers.ScheduledAction;
import com.zoyi.rx.internal.util.PlatformDependent;
import com.zoyi.rx.internal.util.RxThreadFactory;
import com.zoyi.rx.internal.util.SubscriptionList;
import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class NewThreadWorker
extends Scheduler$Worker
implements Subscription {
    private final ScheduledExecutorService executor;
    volatile boolean isUnsubscribed;
    private static final String FREQUENCY_KEY = "com.zoyi.rx.scheduler.jdk6.purge-frequency-millis";
    private static final String PURGE_FORCE_KEY = "com.zoyi.rx.scheduler.jdk6.purge-force";
    private static final String PURGE_THREAD_PREFIX = "RxSchedulerPurge-";
    private static final boolean SHOULD_TRY_ENABLE_CANCEL_POLICY;
    public static final int PURGE_FREQUENCY;
    private static final ConcurrentHashMap<ScheduledThreadPoolExecutor, ScheduledThreadPoolExecutor> EXECUTORS;
    private static final AtomicReference<ScheduledExecutorService> PURGE;
    private static volatile Object cachedSetRemoveOnCancelPolicyMethod;
    private static final Object SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED;

    public static void registerExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        ScheduledExecutorService scheduledExecutorService;
        while ((scheduledExecutorService = PURGE.get()) == null) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1, new RxThreadFactory(PURGE_THREAD_PREFIX));
            if (PURGE.compareAndSet(null, scheduledExecutorService)) {
                scheduledExecutorService.scheduleAtFixedRate(new NewThreadWorker$1(), PURGE_FREQUENCY, PURGE_FREQUENCY, TimeUnit.MILLISECONDS);
                break;
            }
            scheduledExecutorService.shutdownNow();
        }
        EXECUTORS.putIfAbsent(scheduledThreadPoolExecutor, scheduledThreadPoolExecutor);
    }

    public static void deregisterExecutor(ScheduledExecutorService scheduledExecutorService) {
        EXECUTORS.remove(scheduledExecutorService);
    }

    @SuppressAnimalSniffer
    static void purgeExecutors() {
        try {
            Iterator iterator = ((ConcurrentHashMap.KeySetView)EXECUTORS.keySet()).iterator();
            while (iterator.hasNext()) {
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)iterator.next();
                if (!scheduledThreadPoolExecutor.isShutdown()) {
                    scheduledThreadPoolExecutor.purge();
                    continue;
                }
                iterator.remove();
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwIfFatal(throwable);
            RxJavaHooks.onError(throwable2);
            return;
        }
    }

    public static boolean tryEnableCancelPolicy(ScheduledExecutorService scheduledExecutorService) {
        if (SHOULD_TRY_ENABLE_CANCEL_POLICY) {
            Object object;
            boolean bl = scheduledExecutorService instanceof ScheduledThreadPoolExecutor;
            if (bl) {
                object = cachedSetRemoveOnCancelPolicyMethod;
                if (object == SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED) {
                    return false;
                }
                if (object == null) {
                    object = NewThreadWorker.findSetRemoveOnCancelPolicyMethod(scheduledExecutorService);
                    cachedSetRemoveOnCancelPolicyMethod = object != null ? object : SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED;
                } else {
                    object = (Method)object;
                }
            } else {
                object = NewThreadWorker.findSetRemoveOnCancelPolicyMethod(scheduledExecutorService);
            }
            if (object != null) {
                try {
                    ((Method)object).invoke((Object)scheduledExecutorService, true);
                    return true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException;
                    RxJavaHooks.onError(invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object = illegalAccessException;
                    RxJavaHooks.onError(illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = illegalArgumentException;
                    RxJavaHooks.onError(illegalArgumentException);
                }
            }
        }
        return false;
    }

    static Method findSetRemoveOnCancelPolicyMethod(ScheduledExecutorService methodArray) {
        for (Method method : methodArray.getClass().getMethods()) {
            Class<?>[] classArray;
            if (!method.getName().equals("setRemoveOnCancelPolicy") || (classArray = method.getParameterTypes()).length != 1 || classArray[0] != Boolean.TYPE) continue;
            return method;
        }
        return null;
    }

    public NewThreadWorker(ThreadFactory object) {
        object = Executors.newScheduledThreadPool(1, (ThreadFactory)object);
        boolean bl = NewThreadWorker.tryEnableCancelPolicy((ScheduledExecutorService)object);
        if (!bl && object instanceof ScheduledThreadPoolExecutor) {
            NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)object);
        }
        this.executor = object;
    }

    @Override
    public Subscription schedule(Action0 action0) {
        return this.schedule(action0, 0L, null);
    }

    @Override
    public Subscription schedule(Action0 action0, long l2, TimeUnit timeUnit) {
        if (this.isUnsubscribed) {
            return Subscriptions.unsubscribed();
        }
        return this.scheduleActual(action0, l2, timeUnit);
    }

    public ScheduledAction scheduleActual(Action0 object, long l2, TimeUnit timeUnit) {
        object = RxJavaHooks.onScheduledAction((Action0)object);
        object = new ScheduledAction((Action0)object);
        Future<?> future = l2 <= 0L ? this.executor.submit((Runnable)object) : this.executor.schedule((Runnable)object, l2, timeUnit);
        ((ScheduledAction)object).add(future);
        return object;
    }

    public ScheduledAction scheduleActual(Action0 object, long l2, TimeUnit timeUnit, CompositeSubscription compositeSubscription) {
        object = RxJavaHooks.onScheduledAction((Action0)object);
        object = new ScheduledAction((Action0)object, compositeSubscription);
        compositeSubscription.add((Subscription)object);
        Future<?> future = l2 <= 0L ? this.executor.submit((Runnable)object) : this.executor.schedule((Runnable)object, l2, timeUnit);
        ((ScheduledAction)object).add(future);
        return object;
    }

    public ScheduledAction scheduleActual(Action0 object, long l2, TimeUnit timeUnit, SubscriptionList subscriptionList) {
        object = RxJavaHooks.onScheduledAction((Action0)object);
        object = new ScheduledAction((Action0)object, subscriptionList);
        subscriptionList.add((Subscription)object);
        Future<?> future = l2 <= 0L ? this.executor.submit((Runnable)object) : this.executor.schedule((Runnable)object, l2, timeUnit);
        ((ScheduledAction)object).add(future);
        return object;
    }

    @Override
    public void unsubscribe() {
        this.isUnsubscribed = true;
        this.executor.shutdownNow();
        NewThreadWorker.deregisterExecutor(this.executor);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.isUnsubscribed;
    }

    static {
        SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED = new Object();
        EXECUTORS = new ConcurrentHashMap();
        PURGE = new AtomicReference();
        PURGE_FREQUENCY = Integer.getInteger(FREQUENCY_KEY, 1000);
        boolean bl = Boolean.getBoolean(PURGE_FORCE_KEY);
        int n2 = PlatformDependent.getAndroidApiVersion();
        SHOULD_TRY_ENABLE_CANCEL_POLICY = !bl && (n2 == 0 || n2 >= 21);
    }
}

