/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.schedulers.EventLoopsScheduler$EventLoopWorker;
import com.zoyi.rx.internal.schedulers.EventLoopsScheduler$FixedSchedulerPool;
import com.zoyi.rx.internal.schedulers.EventLoopsScheduler$PoolWorker;
import com.zoyi.rx.internal.schedulers.SchedulerLifecycle;
import com.zoyi.rx.internal.util.RxThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class EventLoopsScheduler
extends Scheduler
implements SchedulerLifecycle {
    static final String KEY_MAX_THREADS = "com.zoyi.rx.scheduler.max-computation-threads";
    static final int MAX_THREADS;
    static final EventLoopsScheduler$PoolWorker SHUTDOWN_WORKER;
    static final EventLoopsScheduler$FixedSchedulerPool NONE;
    final ThreadFactory threadFactory;
    final AtomicReference<EventLoopsScheduler$FixedSchedulerPool> pool;

    public EventLoopsScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.pool = new AtomicReference<EventLoopsScheduler$FixedSchedulerPool>(NONE);
        this.start();
    }

    @Override
    public final Scheduler$Worker createWorker() {
        return new EventLoopsScheduler$EventLoopWorker(this.pool.get().getEventLoop());
    }

    @Override
    public final void start() {
        EventLoopsScheduler$FixedSchedulerPool eventLoopsScheduler$FixedSchedulerPool = new EventLoopsScheduler$FixedSchedulerPool(this.threadFactory, MAX_THREADS);
        if (!this.pool.compareAndSet(NONE, eventLoopsScheduler$FixedSchedulerPool)) {
            eventLoopsScheduler$FixedSchedulerPool.shutdown();
        }
    }

    @Override
    public final void shutdown() {
        EventLoopsScheduler$FixedSchedulerPool eventLoopsScheduler$FixedSchedulerPool;
        do {
            if ((eventLoopsScheduler$FixedSchedulerPool = this.pool.get()) != NONE) continue;
            return;
        } while (!this.pool.compareAndSet(eventLoopsScheduler$FixedSchedulerPool, NONE));
        eventLoopsScheduler$FixedSchedulerPool.shutdown();
    }

    public final Subscription scheduleDirect(Action0 action0) {
        EventLoopsScheduler$PoolWorker eventLoopsScheduler$PoolWorker = this.pool.get().getEventLoop();
        return eventLoopsScheduler$PoolWorker.scheduleActual(action0, -1L, TimeUnit.NANOSECONDS);
    }

    static {
        int n2 = Integer.getInteger(KEY_MAX_THREADS, 0);
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n2 <= 0 || n2 > n3) {
            n2 = n3;
        }
        MAX_THREADS = n2;
        SHUTDOWN_WORKER = new EventLoopsScheduler$PoolWorker(RxThreadFactory.NONE);
        SHUTDOWN_WORKER.unsubscribe();
        NONE = new EventLoopsScheduler$FixedSchedulerPool(null, 0);
    }
}

