/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.internal.schedulers.CachedThreadScheduler$CachedWorkerPool;
import com.zoyi.rx.internal.schedulers.CachedThreadScheduler$EventLoopWorker;
import com.zoyi.rx.internal.schedulers.CachedThreadScheduler$ThreadWorker;
import com.zoyi.rx.internal.schedulers.SchedulerLifecycle;
import com.zoyi.rx.internal.util.RxThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class CachedThreadScheduler
extends Scheduler
implements SchedulerLifecycle {
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final TimeUnit KEEP_ALIVE_UNIT = TimeUnit.SECONDS;
    static final CachedThreadScheduler$ThreadWorker SHUTDOWN_THREADWORKER = new CachedThreadScheduler$ThreadWorker(RxThreadFactory.NONE);
    static final CachedThreadScheduler$CachedWorkerPool NONE;
    final ThreadFactory threadFactory;
    final AtomicReference<CachedThreadScheduler$CachedWorkerPool> pool;

    public CachedThreadScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.pool = new AtomicReference<CachedThreadScheduler$CachedWorkerPool>(NONE);
        this.start();
    }

    @Override
    public final void start() {
        CachedThreadScheduler$CachedWorkerPool cachedThreadScheduler$CachedWorkerPool = new CachedThreadScheduler$CachedWorkerPool(this.threadFactory, 60L, KEEP_ALIVE_UNIT);
        if (!this.pool.compareAndSet(NONE, cachedThreadScheduler$CachedWorkerPool)) {
            cachedThreadScheduler$CachedWorkerPool.shutdown();
        }
    }

    @Override
    public final void shutdown() {
        CachedThreadScheduler$CachedWorkerPool cachedThreadScheduler$CachedWorkerPool;
        do {
            if ((cachedThreadScheduler$CachedWorkerPool = this.pool.get()) != NONE) continue;
            return;
        } while (!this.pool.compareAndSet(cachedThreadScheduler$CachedWorkerPool, NONE));
        cachedThreadScheduler$CachedWorkerPool.shutdown();
    }

    @Override
    public final Scheduler$Worker createWorker() {
        return new CachedThreadScheduler$EventLoopWorker(this.pool.get());
    }

    static {
        SHUTDOWN_THREADWORKER.unsubscribe();
        NONE = new CachedThreadScheduler$CachedWorkerPool(null, 0L, null);
        NONE.shutdown();
    }
}

