/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.concurrent.atomic.AtomicInteger;

public final class SingleDelayedProducer<T>
extends AtomicInteger
implements Producer {
    private static final long serialVersionUID = -2873467947112093874L;
    final Subscriber<? super T> child;
    T value;
    static final int NO_REQUEST_NO_VALUE = 0;
    static final int NO_REQUEST_HAS_VALUE = 1;
    static final int HAS_REQUEST_NO_VALUE = 2;
    static final int HAS_REQUEST_HAS_VALUE = 3;

    public SingleDelayedProducer(Subscriber<? super T> subscriber) {
        this.child = subscriber;
    }

    @Override
    public final void request(long l2) {
        block5: {
            int n2;
            if (l2 < 0L) {
                throw new IllegalArgumentException("n >= 0 required");
            }
            if (l2 == 0L) {
                return;
            }
            while ((n2 = this.get()) == 0) {
                if (!this.compareAndSet(0, 2)) {
                    continue;
                }
                break block5;
            }
            if (n2 == 1 && this.compareAndSet(1, 3)) {
                SingleDelayedProducer.emit(this.child, this.value);
            }
        }
    }

    public final void setValue(T t2) {
        block3: {
            int n2;
            while ((n2 = this.get()) == 0) {
                this.value = t2;
                if (!this.compareAndSet(0, 1)) {
                    continue;
                }
                break block3;
            }
            if (n2 == 2 && this.compareAndSet(2, 3)) {
                SingleDelayedProducer.emit(this.child, t2);
            }
        }
    }

    private static <T> void emit(Subscriber<? super T> subscriber, T t2) {
        if (subscriber.isUnsubscribed()) {
            return;
        }
        try {
            subscriber.onNext(t2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwOrReport(throwable, subscriber, t2);
            return;
        }
        if (subscriber.isUnsubscribed()) {
            return;
        }
        subscriber.onCompleted();
    }
}

