/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.util.atomic.SpscLinkedAtomicQueue;
import com.zoyi.rx.internal.util.unsafe.SpscLinkedQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class QueuedProducer<T>
extends AtomicLong
implements Observer<T>,
Producer {
    private static final long serialVersionUID = 7277121710709137047L;
    final Subscriber<? super T> child;
    final Queue<Object> queue;
    final AtomicInteger wip;
    Throwable error;
    volatile boolean done;
    static final Object NULL_SENTINEL = new Object();

    public QueuedProducer(Subscriber<? super T> subscriber) {
        this(subscriber, UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
    }

    public QueuedProducer(Subscriber<? super T> subscriber, Queue<Object> queue) {
        this.child = subscriber;
        this.queue = queue;
        this.wip = new AtomicInteger();
    }

    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (l2 > 0L) {
            BackpressureUtils.getAndAddRequest(this, l2);
            this.drain();
        }
    }

    public final boolean offer(T t2) {
        if (t2 == null ? !this.queue.offer(NULL_SENTINEL) : !this.queue.offer(t2)) {
            return false;
        }
        this.drain();
        return true;
    }

    @Override
    public final void onNext(T t2) {
        if (!this.offer(t2)) {
            this.onError(new MissingBackpressureException());
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        this.error = throwable;
        this.done = true;
        this.drain();
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.drain();
    }

    private boolean checkTerminated(boolean bl, boolean bl2) {
        if (this.child.isUnsubscribed()) {
            return true;
        }
        if (bl) {
            Throwable throwable = this.error;
            if (throwable != null) {
                this.queue.clear();
                this.child.onError(throwable);
                return true;
            }
            if (bl2) {
                this.child.onCompleted();
                return true;
            }
        }
        return false;
    }

    private void drain() {
        if (this.wip.getAndIncrement() == 0) {
            Subscriber<Object> subscriber = this.child;
            Queue<Object> queue = this.queue;
            do {
                if (this.checkTerminated(this.done, queue.isEmpty())) {
                    return;
                }
                this.wip.lazySet(1);
                long l2 = this.get();
                long l3 = 0L;
                while (l2 != 0L) {
                    boolean bl = this.done;
                    Object object = queue.poll();
                    if (this.checkTerminated(bl, object == null)) {
                        return;
                    }
                    if (object == null) break;
                    try {
                        if (object == NULL_SENTINEL) {
                            subscriber.onNext(null);
                        } else {
                            Object object2 = object;
                            subscriber.onNext(object2);
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Exceptions.throwOrReport(throwable, subscriber, object != NULL_SENTINEL ? object : null);
                        return;
                    }
                    --l2;
                    ++l3;
                }
                if (l3 == 0L || this.get() == Long.MAX_VALUE) continue;
                this.addAndGet(-l3);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

