/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.operators.OperatorWindowWithSize$WindowOverlap$WindowOverlapProducer;
import com.zoyi.rx.internal.util.atomic.SpscLinkedArrayQueue;
import com.zoyi.rx.subjects.Subject;
import com.zoyi.rx.subjects.UnicastSubject;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorWindowWithSize$WindowOverlap<T>
extends Subscriber<T>
implements Action0 {
    final Subscriber<? super Observable<T>> actual;
    final int size;
    final int skip;
    final AtomicInteger wip;
    final Subscription cancel;
    final ArrayDeque<Subject<T, T>> windows;
    final AtomicLong requested;
    final AtomicInteger drainWip;
    final Queue<Subject<T, T>> queue;
    Throwable error;
    volatile boolean done;
    int index;
    int produced;

    public OperatorWindowWithSize$WindowOverlap(Subscriber<? super Observable<T>> subscriber, int n2, int n3) {
        this.actual = subscriber;
        this.size = n2;
        this.skip = n3;
        this.wip = new AtomicInteger(1);
        this.windows = new ArrayDeque();
        this.drainWip = new AtomicInteger();
        this.requested = new AtomicLong();
        this.cancel = Subscriptions.create(this);
        this.add(this.cancel);
        this.request(0L);
        int n4 = (n2 + (n3 - 1)) / n3;
        this.queue = new SpscLinkedArrayQueue<Subject<T, T>>(n4);
    }

    @Override
    public final void onNext(T t2) {
        int n2 = this.index;
        ArrayDeque<Subject<T, T>> arrayDeque = this.windows;
        if (n2 == 0 && !this.actual.isUnsubscribed()) {
            this.wip.getAndIncrement();
            UnicastSubject unicastSubject = UnicastSubject.create(16, this);
            arrayDeque.offer(unicastSubject);
            this.queue.offer(unicastSubject);
            this.drain();
        }
        for (Subject<T, T> subject : this.windows) {
            subject.onNext(t2);
        }
        int n3 = this.produced + 1;
        if (n3 == this.size) {
            Subject<T, T> subject;
            this.produced = n3 - this.skip;
            subject = arrayDeque.poll();
            if (subject != null) {
                subject.onCompleted();
            }
        } else {
            this.produced = n3;
        }
        if (++n2 == this.skip) {
            this.index = 0;
            return;
        }
        this.index = n2;
    }

    @Override
    public final void onError(Throwable throwable) {
        for (Subject<T, T> subject : this.windows) {
            subject.onError(throwable);
        }
        this.windows.clear();
        this.error = throwable;
        this.done = true;
        this.drain();
    }

    @Override
    public final void onCompleted() {
        for (Subject<T, T> subject : this.windows) {
            subject.onCompleted();
        }
        this.windows.clear();
        this.done = true;
        this.drain();
    }

    final Producer createProducer() {
        return new OperatorWindowWithSize$WindowOverlap$WindowOverlapProducer(this);
    }

    @Override
    public final void call() {
        if (this.wip.decrementAndGet() == 0) {
            this.unsubscribe();
        }
    }

    final void drain() {
        AtomicInteger atomicInteger = this.drainWip;
        if (atomicInteger.getAndIncrement() != 0) {
            return;
        }
        Subscriber<Observable<Subject<T, T>>> subscriber = this.actual;
        Queue<Subject<T, T>> queue = this.queue;
        int n2 = 1;
        do {
            long l2;
            long l3 = this.requested.get();
            for (l2 = 0L; l2 != l3; ++l2) {
                boolean bl;
                boolean bl2 = this.done;
                Subject<T, T> subject = queue.poll();
                boolean bl3 = bl = subject == null;
                if (this.checkTerminated(bl2, bl, subscriber, queue)) {
                    return;
                }
                if (bl) break;
                subscriber.onNext(subject);
            }
            if (l2 == l3 && this.checkTerminated(this.done, queue.isEmpty(), subscriber, queue)) {
                return;
            }
            if (l2 == 0L || l3 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-l2);
        } while ((n2 = atomicInteger.addAndGet(-n2)) != 0);
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<? super Subject<T, T>> subscriber, Queue<Subject<T, T>> queue) {
        if (subscriber.isUnsubscribed()) {
            queue.clear();
            return true;
        }
        if (bl) {
            Throwable throwable = this.error;
            if (throwable != null) {
                queue.clear();
                subscriber.onError(throwable);
                return true;
            }
            if (bl2) {
                subscriber.onCompleted();
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ void access$300(OperatorWindowWithSize$WindowOverlap operatorWindowWithSize$WindowOverlap, long l2) {
        operatorWindowWithSize$WindowOverlap.request(l2);
    }

    static /* synthetic */ void access$400(OperatorWindowWithSize$WindowOverlap operatorWindowWithSize$WindowOverlap, long l2) {
        operatorWindowWithSize$WindowOverlap.request(l2);
    }
}

