/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorSwitch$InnerSubscriber;
import com.zoyi.rx.internal.operators.OperatorSwitch$SwitchSubscriber$1;
import com.zoyi.rx.internal.operators.OperatorSwitch$SwitchSubscriber$2;
import com.zoyi.rx.internal.util.RxRingBuffer;
import com.zoyi.rx.internal.util.atomic.SpscLinkedArrayQueue;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.SerialSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorSwitch$SwitchSubscriber<T>
extends Subscriber<Observable<? extends T>> {
    final Subscriber<? super T> child;
    final SerialSubscription ssub;
    final boolean delayError;
    final AtomicLong index;
    final SpscLinkedArrayQueue<Object> queue;
    final NotificationLite<T> nl;
    boolean emitting;
    boolean missed;
    long requested;
    Producer producer;
    volatile boolean mainDone;
    Throwable error;
    boolean innerActive;
    static final Throwable TERMINAL_ERROR = new Throwable("Terminal error");

    OperatorSwitch$SwitchSubscriber(Subscriber<? super T> subscriber, boolean bl) {
        this.child = subscriber;
        this.ssub = new SerialSubscription();
        this.delayError = bl;
        this.index = new AtomicLong();
        this.queue = new SpscLinkedArrayQueue(RxRingBuffer.SIZE);
        this.nl = NotificationLite.instance();
    }

    final void init() {
        this.child.add(this.ssub);
        this.child.add(Subscriptions.create(new OperatorSwitch$SwitchSubscriber$1(this)));
        this.child.setProducer(new OperatorSwitch$SwitchSubscriber$2(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clearProducer() {
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            this.producer = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onNext(Observable<? extends T> observable) {
        OperatorSwitch$InnerSubscriber operatorSwitch$InnerSubscriber;
        long l2 = this.index.incrementAndGet();
        Subscription subscription = this.ssub.get();
        if (subscription != null) {
            subscription.unsubscribe();
        }
        subscription = this;
        synchronized (subscription) {
            operatorSwitch$InnerSubscriber = new OperatorSwitch$InnerSubscriber(l2, this);
            this.innerActive = true;
            this.producer = null;
        }
        this.ssub.set(operatorSwitch$InnerSubscriber);
        observable.unsafeSubscribe(operatorSwitch$InnerSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onError(Throwable throwable) {
        boolean bl;
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            bl = this.updateError(throwable);
        }
        if (bl) {
            this.mainDone = true;
            this.drain();
            return;
        }
        this.pluginError(throwable);
    }

    final boolean updateError(Throwable throwable) {
        Serializable serializable = this.error;
        if (serializable == TERMINAL_ERROR) {
            return false;
        }
        if (serializable == null) {
            this.error = throwable;
        } else if (serializable instanceof CompositeException) {
            serializable = new ArrayList<Throwable>(((CompositeException)serializable).getExceptions());
            serializable.add((Throwable)throwable);
            this.error = new CompositeException((Collection<? extends Throwable>)((Object)serializable));
        } else {
            this.error = new CompositeException(new Throwable[]{serializable, throwable});
        }
        return true;
    }

    @Override
    public final void onCompleted() {
        this.mainDone = true;
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void emit(T t2, OperatorSwitch$InnerSubscriber<T> operatorSwitch$InnerSubscriber) {
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            if (this.index.get() != OperatorSwitch$InnerSubscriber.access$000(operatorSwitch$InnerSubscriber)) {
                return;
            }
            this.queue.offer(operatorSwitch$InnerSubscriber, this.nl.next(t2));
        }
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void error(Throwable throwable, long l2) {
        boolean bl;
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            if (this.index.get() == l2) {
                bl = this.updateError(throwable);
                this.innerActive = false;
                this.producer = null;
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.drain();
            return;
        }
        this.pluginError(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void complete(long l2) {
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            if (this.index.get() != l2) {
                return;
            }
            this.innerActive = false;
            this.producer = null;
        }
        this.drain();
    }

    final void pluginError(Throwable throwable) {
        RxJavaHooks.onError(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void innerProducer(Producer producer, long l2) {
        long l3;
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            if (this.index.get() != l2) {
                return;
            }
            l3 = this.requested;
            this.producer = producer;
        }
        producer.request(l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void childRequested(long l2) {
        Producer producer;
        OperatorSwitch$SwitchSubscriber operatorSwitch$SwitchSubscriber = this;
        synchronized (operatorSwitch$SwitchSubscriber) {
            producer = this.producer;
            this.requested = BackpressureUtils.addCap(this.requested, l2);
        }
        if (producer != null) {
            producer.request(l2);
        }
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void drain() {
        Throwable throwable;
        long l2;
        boolean bl;
        Object object = this;
        synchronized (object) {
            if (this.emitting) {
                this.missed = true;
                return;
            }
            this.emitting = true;
            bl = this.innerActive;
            l2 = this.requested;
            throwable = this.error;
            if (throwable != null && throwable != TERMINAL_ERROR && !this.delayError) {
                this.error = TERMINAL_ERROR;
            }
        }
        object = this.queue;
        AtomicLong atomicLong = this.index;
        Subscriber<T> subscriber = this.child;
        boolean bl2 = this.mainDone;
        while (true) {
            Subscriber subscriber2;
            long l3 = 0L;
            while (l3 != l2) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                boolean bl3 = ((SpscLinkedArrayQueue)object).isEmpty();
                if (this.checkTerminated(bl2, bl, throwable, (SpscLinkedArrayQueue<Object>)object, subscriber, bl3)) {
                    return;
                }
                if (bl3) break;
                subscriber2 = (OperatorSwitch$InnerSubscriber)((SpscLinkedArrayQueue)object).poll();
                T t2 = this.nl.getValue(((SpscLinkedArrayQueue)object).poll());
                if (atomicLong.get() != OperatorSwitch$InnerSubscriber.access$000((OperatorSwitch$InnerSubscriber)subscriber2)) continue;
                subscriber.onNext(t2);
                ++l3;
            }
            if (l3 == l2) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                if (this.checkTerminated(this.mainDone, bl, throwable, (SpscLinkedArrayQueue<Object>)object, subscriber, ((SpscLinkedArrayQueue)object).isEmpty())) {
                    return;
                }
            }
            subscriber2 = this;
            synchronized (subscriber2) {
                l2 = this.requested;
                if (l2 != Long.MAX_VALUE) {
                    this.requested = l2 -= l3;
                }
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
                bl2 = this.mainDone;
                bl = this.innerActive;
                throwable = this.error;
                if (throwable != null && throwable != TERMINAL_ERROR && !this.delayError) {
                    this.error = TERMINAL_ERROR;
                }
            }
        }
    }

    protected final boolean checkTerminated(boolean bl, boolean bl2, Throwable throwable, SpscLinkedArrayQueue<Object> spscLinkedArrayQueue, Subscriber<? super T> subscriber, boolean bl3) {
        if (this.delayError) {
            if (bl && !bl2 && bl3) {
                if (throwable != null) {
                    subscriber.onError(throwable);
                } else {
                    subscriber.onCompleted();
                }
                return true;
            }
        } else {
            if (throwable != null) {
                spscLinkedArrayQueue.clear();
                subscriber.onError(throwable);
                return true;
            }
            if (bl && !bl2 && bl3) {
                subscriber.onCompleted();
                return true;
            }
        }
        return false;
    }
}

