/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.producers.SingleProducer;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.NoSuchElementException;

final class OperatorSingle$ParentSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> child;
    private final boolean hasDefaultValue;
    private final T defaultValue;
    private T value;
    private boolean isNonEmpty;
    private boolean hasTooManyElements;

    OperatorSingle$ParentSubscriber(Subscriber<? super T> subscriber, boolean bl, T t2) {
        this.child = subscriber;
        this.hasDefaultValue = bl;
        this.defaultValue = t2;
        this.request(2L);
    }

    @Override
    public final void onNext(T t2) {
        if (this.hasTooManyElements) {
            return;
        }
        if (this.isNonEmpty) {
            this.hasTooManyElements = true;
            this.child.onError(new IllegalArgumentException("Sequence contains too many elements"));
            this.unsubscribe();
            return;
        }
        this.value = t2;
        this.isNonEmpty = true;
    }

    @Override
    public final void onCompleted() {
        if (!this.hasTooManyElements) {
            if (this.isNonEmpty) {
                this.child.setProducer(new SingleProducer<T>(this.child, this.value));
                return;
            }
            if (this.hasDefaultValue) {
                this.child.setProducer(new SingleProducer<T>(this.child, this.defaultValue));
                return;
            }
            this.child.onError(new NoSuchElementException("Sequence contains no elements"));
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.hasTooManyElements) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.child.onError(throwable);
    }
}

