/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorObserveOn$ObserveOnSubscriber$1;
import com.zoyi.rx.internal.util.RxRingBuffer;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorObserveOn$ObserveOnSubscriber<T>
extends Subscriber<T>
implements Action0 {
    final Subscriber<? super T> child;
    final Scheduler$Worker recursiveScheduler;
    final NotificationLite<T> on;
    final boolean delayError;
    final Queue<Object> queue;
    final int limit;
    volatile boolean finished;
    final AtomicLong requested = new AtomicLong();
    final AtomicLong counter = new AtomicLong();
    Throwable error;
    long emitted;

    public OperatorObserveOn$ObserveOnSubscriber(Scheduler scheduler, Subscriber<? super T> subscriber, boolean bl, int n2) {
        this.child = subscriber;
        this.recursiveScheduler = scheduler.createWorker();
        this.delayError = bl;
        this.on = NotificationLite.instance();
        int n3 = n2 > 0 ? n2 : RxRingBuffer.SIZE;
        this.limit = n3 - (n3 >> 2);
        this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(n3) : new SpscAtomicArrayQueue<Object>(n3);
        this.request(n3);
    }

    final void init() {
        Subscriber<T> subscriber = this.child;
        subscriber.setProducer(new OperatorObserveOn$ObserveOnSubscriber$1(this));
        subscriber.add(this.recursiveScheduler);
        subscriber.add(this);
    }

    @Override
    public final void onNext(T t2) {
        if (this.isUnsubscribed() || this.finished) {
            return;
        }
        if (!this.queue.offer(this.on.next(t2))) {
            this.onError(new MissingBackpressureException());
            return;
        }
        this.schedule();
    }

    @Override
    public final void onCompleted() {
        if (this.isUnsubscribed() || this.finished) {
            return;
        }
        this.finished = true;
        this.schedule();
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.isUnsubscribed() || this.finished) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.error = throwable;
        this.finished = true;
        this.schedule();
    }

    protected final void schedule() {
        if (this.counter.getAndIncrement() == 0L) {
            this.recursiveScheduler.schedule(this);
        }
    }

    @Override
    public final void call() {
        long l2 = 1L;
        long l3 = this.emitted;
        Queue<Object> queue = this.queue;
        Subscriber<T> subscriber = this.child;
        NotificationLite<T> notificationLite = this.on;
        do {
            long l4 = this.requested.get();
            while (l4 != l3) {
                boolean bl;
                boolean bl2 = this.finished;
                Object object = queue.poll();
                boolean bl3 = bl = object == null;
                if (this.checkTerminated(bl2, bl, subscriber, queue)) {
                    return;
                }
                if (bl) break;
                subscriber.onNext(notificationLite.getValue(object));
                if (++l3 != (long)this.limit) continue;
                l4 = BackpressureUtils.produced(this.requested, l3);
                this.request(l3);
                l3 = 0L;
            }
            if (l4 == l3 && this.checkTerminated(this.finished, queue.isEmpty(), subscriber, queue)) {
                return;
            }
            this.emitted = l3;
        } while ((l2 = this.counter.addAndGet(-l2)) != 0L);
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<? super T> subscriber, Queue<Object> queue) {
        if (subscriber.isUnsubscribed()) {
            queue.clear();
            return true;
        }
        if (bl) {
            if (this.delayError) {
                if (bl2) {
                    Throwable throwable = this.error;
                    try {
                        if (throwable != null) {
                            subscriber.onError(throwable);
                        }
                        subscriber.onCompleted();
                    }
                    finally {
                        this.recursiveScheduler.unsubscribe();
                    }
                }
            } else {
                Throwable throwable = this.error;
                if (throwable != null) {
                    queue.clear();
                    try {
                        subscriber.onError(throwable);
                    }
                    finally {
                        this.recursiveScheduler.unsubscribe();
                    }
                    return true;
                }
                if (bl2) {
                    try {
                        subscriber.onCompleted();
                    }
                    finally {
                        this.recursiveScheduler.unsubscribe();
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

