/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorMerge$InnerSubscriber;
import com.zoyi.rx.internal.operators.OperatorMerge$MergeProducer;
import com.zoyi.rx.internal.util.RxRingBuffer;
import com.zoyi.rx.internal.util.ScalarSynchronousObservable;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.atomic.SpscExactAtomicArrayQueue;
import com.zoyi.rx.internal.util.atomic.SpscUnboundedAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.Pow2;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

final class OperatorMerge$MergeSubscriber<T>
extends Subscriber<Observable<? extends T>> {
    final Subscriber<? super T> child;
    final boolean delayErrors;
    final int maxConcurrent;
    OperatorMerge$MergeProducer<T> producer;
    volatile Queue<Object> queue;
    volatile CompositeSubscription subscriptions;
    volatile ConcurrentLinkedQueue<Throwable> errors;
    final NotificationLite<T> nl;
    volatile boolean done;
    boolean emitting;
    boolean missed;
    final Object innerGuard;
    volatile OperatorMerge$InnerSubscriber<?>[] innerSubscribers;
    long uniqueId;
    long lastId;
    int lastIndex;
    static final OperatorMerge$InnerSubscriber<?>[] EMPTY = new OperatorMerge$InnerSubscriber[0];
    final int scalarEmissionLimit;
    int scalarEmissionCount;

    public OperatorMerge$MergeSubscriber(Subscriber<? super T> subscriber, boolean bl, int n2) {
        this.child = subscriber;
        this.delayErrors = bl;
        this.maxConcurrent = n2;
        this.nl = NotificationLite.instance();
        this.innerGuard = new Object();
        this.innerSubscribers = EMPTY;
        if (n2 == Integer.MAX_VALUE) {
            this.scalarEmissionLimit = Integer.MAX_VALUE;
            this.request(Long.MAX_VALUE);
            return;
        }
        this.scalarEmissionLimit = Math.max(1, n2 >> 1);
        this.request(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Queue<Throwable> getOrCreateErrorQueue() {
        ConcurrentLinkedQueue<Throwable> concurrentLinkedQueue = this.errors;
        if (concurrentLinkedQueue == null) {
            OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
            synchronized (operatorMerge$MergeSubscriber) {
                concurrentLinkedQueue = this.errors;
                if (concurrentLinkedQueue == null) {
                    this.errors = concurrentLinkedQueue = new ConcurrentLinkedQueue();
                }
            }
        }
        return concurrentLinkedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CompositeSubscription getOrCreateComposite() {
        CompositeSubscription compositeSubscription = this.subscriptions;
        if (compositeSubscription == null) {
            boolean bl = false;
            OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
            synchronized (operatorMerge$MergeSubscriber) {
                compositeSubscription = this.subscriptions;
                if (compositeSubscription == null) {
                    this.subscriptions = compositeSubscription = new CompositeSubscription();
                    bl = true;
                }
            }
            if (bl) {
                this.add(compositeSubscription);
            }
        }
        return compositeSubscription;
    }

    @Override
    public final void onNext(Observable<? extends T> observable) {
        if (observable == null) {
            return;
        }
        if (observable == Observable.empty()) {
            this.emitEmpty();
            return;
        }
        if (observable instanceof ScalarSynchronousObservable) {
            this.tryEmit(((ScalarSynchronousObservable)observable).get());
            return;
        }
        OperatorMerge$InnerSubscriber operatorMerge$InnerSubscriber = new OperatorMerge$InnerSubscriber(this, this.uniqueId++);
        this.addInner(operatorMerge$InnerSubscriber);
        observable.unsafeSubscribe(operatorMerge$InnerSubscriber);
        this.emit();
    }

    final void emitEmpty() {
        int n2 = this.scalarEmissionCount + 1;
        if (n2 == this.scalarEmissionLimit) {
            this.scalarEmissionCount = 0;
            this.requestMore(n2);
            return;
        }
        this.scalarEmissionCount = n2;
    }

    private void reportError() {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(this.errors);
        if (arrayList.size() == 1) {
            this.child.onError((Throwable)arrayList.get(0));
            return;
        }
        this.child.onError(new CompositeException(arrayList));
    }

    @Override
    public final void onError(Throwable throwable) {
        this.getOrCreateErrorQueue().offer(throwable);
        this.done = true;
        this.emit();
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addInner(OperatorMerge$InnerSubscriber<T> operatorMerge$InnerSubscriber) {
        this.getOrCreateComposite().add(operatorMerge$InnerSubscriber);
        Object object = this.innerGuard;
        synchronized (object) {
            OperatorMerge$InnerSubscriber<?>[] operatorMerge$InnerSubscriberArray = this.innerSubscribers;
            int n2 = this.innerSubscribers.length;
            OperatorMerge$InnerSubscriber[] operatorMerge$InnerSubscriberArray2 = new OperatorMerge$InnerSubscriber[n2 + 1];
            System.arraycopy(operatorMerge$InnerSubscriberArray, 0, operatorMerge$InnerSubscriberArray2, 0, n2);
            operatorMerge$InnerSubscriberArray2[n2] = operatorMerge$InnerSubscriber;
            this.innerSubscribers = operatorMerge$InnerSubscriberArray2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeInner(OperatorMerge$InnerSubscriber<T> operatorMerge$InnerSubscriber) {
        Object object = operatorMerge$InnerSubscriber.queue;
        if (object != null) {
            ((RxRingBuffer)object).release();
        }
        this.subscriptions.remove(operatorMerge$InnerSubscriber);
        object = this.innerGuard;
        synchronized (object) {
            OperatorMerge$InnerSubscriber<?>[] operatorMerge$InnerSubscriberArray = this.innerSubscribers;
            int n2 = this.innerSubscribers.length;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!operatorMerge$InnerSubscriber.equals(operatorMerge$InnerSubscriberArray[i2])) continue;
                n3 = i2;
                break;
            }
            if (n3 < 0) {
                return;
            }
            if (n2 == 1) {
                this.innerSubscribers = EMPTY;
                return;
            }
            OperatorMerge$InnerSubscriber[] operatorMerge$InnerSubscriberArray2 = new OperatorMerge$InnerSubscriber[n2 - 1];
            System.arraycopy(operatorMerge$InnerSubscriberArray, 0, operatorMerge$InnerSubscriberArray2, 0, n3);
            System.arraycopy(operatorMerge$InnerSubscriberArray, n3 + 1, operatorMerge$InnerSubscriberArray2, n3, n2 - n3 - 1);
            this.innerSubscribers = operatorMerge$InnerSubscriberArray2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void tryEmit(OperatorMerge$InnerSubscriber<T> operatorMerge$InnerSubscriber, T t2) {
        void var2_2;
        Subscription subscription;
        boolean bl = false;
        long l2 = this.producer.get();
        if (l2 != 0L) {
            subscription = this;
            synchronized (subscription) {
                l2 = this.producer.get();
                if (!this.emitting && l2 != 0L) {
                    this.emitting = true;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.queueScalar(operatorMerge$InnerSubscriber, var2_2);
            this.emit();
            return;
        }
        subscription = operatorMerge$InnerSubscriber.queue;
        if (subscription != null && !((RxRingBuffer)subscription).isEmpty()) {
            this.queueScalar(operatorMerge$InnerSubscriber, var2_2);
            this.emitLoop();
            return;
        }
        this.emitScalar(operatorMerge$InnerSubscriber, var2_2, l2);
    }

    protected final void queueScalar(OperatorMerge$InnerSubscriber<T> operatorMerge$InnerSubscriber, T t2) {
        RxRingBuffer rxRingBuffer = operatorMerge$InnerSubscriber.queue;
        if (rxRingBuffer == null) {
            rxRingBuffer = RxRingBuffer.getSpscInstance();
            operatorMerge$InnerSubscriber.add(rxRingBuffer);
            operatorMerge$InnerSubscriber.queue = rxRingBuffer;
        }
        try {
            rxRingBuffer.onNext(this.nl.next(t2));
            return;
        }
        catch (MissingBackpressureException missingBackpressureException) {
            operatorMerge$InnerSubscriber.unsubscribe();
            operatorMerge$InnerSubscriber.onError(missingBackpressureException);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            if (!operatorMerge$InnerSubscriber.isUnsubscribed()) {
                operatorMerge$InnerSubscriber.unsubscribe();
                operatorMerge$InnerSubscriber.onError(illegalStateException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void emitScalar(OperatorMerge$InnerSubscriber<T> operatorMerge$InnerSubscriber, T object, long l2) {
        boolean bl = false;
        try {
            try {
                this.child.onNext(object);
            }
            catch (Throwable throwable) {
                if (!this.delayErrors) {
                    Exceptions.throwIfFatal(throwable);
                    bl = true;
                    operatorMerge$InnerSubscriber.unsubscribe();
                    operatorMerge$InnerSubscriber.onError(throwable);
                    return;
                }
                this.getOrCreateErrorQueue().offer(throwable);
            }
            if (l2 != Long.MAX_VALUE) {
                this.producer.produced(1);
            }
            operatorMerge$InnerSubscriber.requestMore(1L);
            object = this;
            synchronized (object) {
                bl = true;
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
            }
        }
        catch (Throwable throwable) {
            if (!bl) {
                object = this;
                synchronized (object) {
                    this.emitting = false;
                }
            }
            throw throwable;
        }
        this.emitLoop();
    }

    public final void requestMore(long l2) {
        this.request(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void tryEmit(T t2) {
        Queue<Object> queue;
        boolean bl = false;
        long l2 = this.producer.get();
        if (l2 != 0L) {
            queue = this;
            synchronized (queue) {
                l2 = this.producer.get();
                if (!this.emitting && l2 != 0L) {
                    this.emitting = true;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.queueScalar(t2);
            this.emit();
            return;
        }
        queue = this.queue;
        if (queue != null && !queue.isEmpty()) {
            this.queueScalar(t2);
            this.emitLoop();
            return;
        }
        this.emitScalar(t2, l2);
    }

    protected final void queueScalar(T t2) {
        Queue<Object> queue = this.queue;
        if (queue == null) {
            int n2 = this.maxConcurrent;
            queue = n2 == Integer.MAX_VALUE ? new SpscUnboundedAtomicArrayQueue<Object>(RxRingBuffer.SIZE) : (Pow2.isPowerOfTwo(n2) ? (UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(n2) : new SpscAtomicArrayQueue<Object>(n2)) : new SpscExactAtomicArrayQueue<Object>(n2));
            this.queue = queue;
        }
        if (!queue.offer(this.nl.next(t2))) {
            this.unsubscribe();
            this.onError(OnErrorThrowable.addValueAsLastCause(new MissingBackpressureException(), t2));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void emitScalar(T t2, long l2) {
        boolean bl = false;
        try {
            int n2;
            try {
                this.child.onNext(t2);
            }
            catch (Throwable throwable) {
                if (!this.delayErrors) {
                    Exceptions.throwIfFatal(throwable);
                    bl = true;
                    this.unsubscribe();
                    this.onError(throwable);
                    return;
                }
                this.getOrCreateErrorQueue().offer(throwable);
            }
            if (l2 != Long.MAX_VALUE) {
                this.producer.produced(1);
            }
            if ((n2 = this.scalarEmissionCount + 1) == this.scalarEmissionLimit) {
                this.scalarEmissionCount = 0;
                this.requestMore(n2);
            } else {
                this.scalarEmissionCount = n2;
            }
            OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
            synchronized (operatorMerge$MergeSubscriber) {
                bl = true;
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
            }
        }
        catch (Throwable throwable) {
            if (!bl) {
                OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
                synchronized (operatorMerge$MergeSubscriber) {
                    this.emitting = false;
                }
            }
            throw throwable;
        }
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void emit() {
        OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
        synchronized (operatorMerge$MergeSubscriber) {
            if (this.emitting) {
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void emitLoop() {
        boolean bl = false;
        try {
            Subscriber<T> subscriber = this.child;
            while (true) {
                int n2;
                if (this.checkTerminate()) {
                    return;
                }
                Queue<Object> queue = this.queue;
                long l2 = this.producer.get();
                boolean bl2 = l2 == Long.MAX_VALUE;
                int n3 = 0;
                if (queue != null) {
                    void var9_16;
                    do {
                        n2 = 0;
                        Object var9_15 = null;
                        while (l2 > 0L) {
                            Object object = queue.poll();
                            if (this.checkTerminate()) {
                                return;
                            }
                            if (object == null) break;
                            T t2 = this.nl.getValue(object);
                            try {
                                subscriber.onNext(t2);
                            }
                            catch (Throwable throwable) {
                                if (!this.delayErrors) {
                                    Exceptions.throwIfFatal(throwable);
                                    bl = true;
                                    this.unsubscribe();
                                    subscriber.onError(throwable);
                                    return;
                                }
                                this.getOrCreateErrorQueue().offer(throwable);
                            }
                            ++n3;
                            ++n2;
                            --l2;
                        }
                        if (n2 <= 0) continue;
                        l2 = bl2 ? Long.MAX_VALUE : this.producer.produced(n2);
                    } while (l2 != 0L && var9_16 != null);
                }
                n2 = this.done;
                queue = this.queue;
                OperatorMerge$InnerSubscriber<?>[] operatorMerge$InnerSubscriberArray = this.innerSubscribers;
                int n4 = this.innerSubscribers.length;
                if (n2 != 0 && (queue == null || queue.isEmpty()) && n4 == 0) {
                    ConcurrentLinkedQueue<Throwable> concurrentLinkedQueue = this.errors;
                    if (concurrentLinkedQueue != null && !concurrentLinkedQueue.isEmpty()) {
                        this.reportError();
                        return;
                    }
                    subscriber.onCompleted();
                    return;
                }
                boolean bl3 = false;
                if (n4 > 0) {
                    long l3 = this.lastId;
                    int n5 = this.lastIndex;
                    if (n4 <= n5 || operatorMerge$InnerSubscriberArray[n5].id != l3) {
                        if (n4 <= n5) {
                            n5 = 0;
                        }
                        n2 = n5;
                        for (n5 = 0; n5 < n4 && operatorMerge$InnerSubscriberArray[n2].id != l3; ++n5) {
                            if (++n2 != n4) continue;
                            n2 = 0;
                        }
                        n5 = n2;
                        this.lastIndex = n2;
                        this.lastId = operatorMerge$InnerSubscriberArray[n2].id;
                    }
                    n2 = n5;
                    for (n5 = 0; n5 < n4; ++n5) {
                        int n6;
                        if (this.checkTerminate()) {
                            return;
                        }
                        OperatorMerge$InnerSubscriber<?> operatorMerge$InnerSubscriber = operatorMerge$InnerSubscriberArray[n2];
                        Object object = null;
                        do {
                            n6 = 0;
                            while (l2 > 0L) {
                                if (this.checkTerminate()) {
                                    return;
                                }
                                RxRingBuffer rxRingBuffer = operatorMerge$InnerSubscriber.queue;
                                if (rxRingBuffer == null || (object = rxRingBuffer.poll()) == null) break;
                                T t3 = this.nl.getValue(object);
                                try {
                                    subscriber.onNext(t3);
                                }
                                catch (Throwable throwable) {
                                    bl = true;
                                    Exceptions.throwIfFatal(throwable);
                                    try {
                                        subscriber.onError(throwable);
                                        return;
                                    }
                                    finally {
                                        this.unsubscribe();
                                    }
                                }
                                --l2;
                                ++n6;
                            }
                            if (n6 <= 0) continue;
                            l2 = !bl2 ? this.producer.produced(n6) : Long.MAX_VALUE;
                            operatorMerge$InnerSubscriber.requestMore(n6);
                        } while (l2 != 0L && object != null);
                        n6 = operatorMerge$InnerSubscriber.done ? 1 : 0;
                        RxRingBuffer rxRingBuffer = operatorMerge$InnerSubscriber.queue;
                        if (n6 != 0 && (rxRingBuffer == null || rxRingBuffer.isEmpty())) {
                            this.removeInner(operatorMerge$InnerSubscriber);
                            if (this.checkTerminate()) {
                                return;
                            }
                            ++n3;
                            bl3 = true;
                        }
                        if (l2 == 0L) break;
                        if (++n2 != n4) continue;
                        n2 = 0;
                    }
                    this.lastIndex = n2;
                    this.lastId = operatorMerge$InnerSubscriberArray[n2].id;
                }
                if (n3 > 0) {
                    this.request(n3);
                }
                if (bl3) continue;
                OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
                synchronized (operatorMerge$MergeSubscriber) {
                    if (!this.missed) {
                        bl = true;
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                }
            }
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            OperatorMerge$MergeSubscriber operatorMerge$MergeSubscriber = this;
            synchronized (operatorMerge$MergeSubscriber) {
                this.emitting = false;
                throw throwable;
            }
        }
    }

    final boolean checkTerminate() {
        if (this.child.isUnsubscribed()) {
            return true;
        }
        ConcurrentLinkedQueue<Throwable> concurrentLinkedQueue = this.errors;
        if (!this.delayErrors && concurrentLinkedQueue != null && !concurrentLinkedQueue.isEmpty()) {
            try {
                this.reportError();
            }
            finally {
                this.unsubscribe();
            }
            return true;
        }
        return false;
    }
}

