/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicLong;

class OperatorMaterialize$ParentSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super Notification<T>> child;
    private volatile Notification<T> terminalNotification;
    private boolean busy;
    private boolean missed;
    private final AtomicLong requested = new AtomicLong();

    OperatorMaterialize$ParentSubscriber(Subscriber<? super Notification<T>> subscriber) {
        this.child = subscriber;
    }

    @Override
    public void onStart() {
        this.request(0L);
    }

    void requestMore(long l2) {
        BackpressureUtils.getAndAddRequest(this.requested, l2);
        this.request(l2);
        this.drain();
    }

    @Override
    public void onCompleted() {
        this.terminalNotification = Notification.createOnCompleted();
        this.drain();
    }

    @Override
    public void onError(Throwable throwable) {
        this.terminalNotification = Notification.createOnError(throwable);
        RxJavaHooks.onError(throwable);
        this.drain();
    }

    @Override
    public void onNext(T t2) {
        this.child.onNext(Notification.createOnNext(t2));
        this.decrementRequested();
    }

    private void decrementRequested() {
        long l2;
        AtomicLong atomicLong = this.requested;
        do {
            if ((l2 = atomicLong.get()) != Long.MAX_VALUE) continue;
            return;
        } while (!atomicLong.compareAndSet(l2, l2 - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        Object object = this;
        synchronized (object) {
            if (this.busy) {
                this.missed = true;
                return;
            }
        }
        object = this.requested;
        while (!this.child.isUnsubscribed()) {
            Notification<T> notification = this.terminalNotification;
            if (notification != null && ((AtomicLong)object).get() > 0L) {
                this.terminalNotification = null;
                this.child.onNext(notification);
                if (!this.child.isUnsubscribed()) {
                    this.child.onCompleted();
                }
                return;
            }
            notification = this;
            synchronized (notification) {
                if (!this.missed) {
                    this.busy = false;
                    return;
                }
            }
        }
    }
}

