/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorGroupBy$GroupBySubscriber;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class OperatorGroupBy$State<T, K>
extends AtomicInteger
implements Observable$OnSubscribe<T>,
Producer,
Subscription {
    private static final long serialVersionUID = -3852313036005250360L;
    final K key;
    final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
    final OperatorGroupBy$GroupBySubscriber<?, K, T> parent;
    final boolean delayError;
    final AtomicLong requested;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean cancelled;
    final AtomicReference<Subscriber<? super T>> actual;
    final AtomicBoolean once;

    public OperatorGroupBy$State(int n2, OperatorGroupBy$GroupBySubscriber<?, K, T> operatorGroupBy$GroupBySubscriber, K k2, boolean bl) {
        this.parent = operatorGroupBy$GroupBySubscriber;
        this.key = k2;
        this.delayError = bl;
        this.cancelled = new AtomicBoolean();
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.requested = new AtomicLong();
    }

    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= required but it was " + l2);
        }
        if (l2 != 0L) {
            BackpressureUtils.getAndAddRequest(this.requested, l2);
            this.drain();
        }
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.cancelled.get();
    }

    @Override
    public final void unsubscribe() {
        if (this.cancelled.compareAndSet(false, true) && this.getAndIncrement() == 0) {
            this.parent.cancel(this.key);
        }
    }

    @Override
    public final void call(Subscriber<? super T> subscriber) {
        if (this.once.compareAndSet(false, true)) {
            subscriber.add(this);
            subscriber.setProducer(this);
            this.actual.lazySet(subscriber);
            this.drain();
            return;
        }
        subscriber.onError(new IllegalStateException("Only one Subscriber allowed!"));
    }

    public final void onNext(T t2) {
        if (t2 == null) {
            this.error = new NullPointerException();
            this.done = true;
        } else {
            this.queue.offer(NotificationLite.instance().next(t2));
        }
        this.drain();
    }

    public final void onError(Throwable throwable) {
        this.error = throwable;
        this.done = true;
        this.drain();
    }

    public final void onComplete() {
        this.done = true;
        this.drain();
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int n2 = 1;
        Queue<Object> queue = this.queue;
        boolean bl = this.delayError;
        Subscriber subscriber = this.actual.get();
        NotificationLite notificationLite = NotificationLite.instance();
        while (true) {
            if (subscriber != null) {
                long l2;
                if (this.checkTerminated(this.done, queue.isEmpty(), subscriber, bl)) {
                    return;
                }
                long l3 = this.requested.get();
                for (l2 = 0L; l2 != l3; ++l2) {
                    boolean bl2;
                    boolean bl3 = this.done;
                    Object object = queue.poll();
                    boolean bl4 = bl2 = object == null;
                    if (this.checkTerminated(bl3, bl2, subscriber, bl)) {
                        return;
                    }
                    if (bl2) break;
                    subscriber.onNext(notificationLite.getValue(object));
                }
                if (l2 != 0L) {
                    if (l3 != Long.MAX_VALUE) {
                        BackpressureUtils.produced(this.requested, l2);
                    }
                    this.parent.s.request(l2);
                }
            }
            if ((n2 = this.addAndGet(-n2)) == 0) break;
            if (subscriber != null) continue;
            subscriber = this.actual.get();
        }
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<? super T> subscriber, boolean bl3) {
        if (this.cancelled.get()) {
            this.queue.clear();
            this.parent.cancel(this.key);
            return true;
        }
        if (bl) {
            if (bl3) {
                if (bl2) {
                    Throwable throwable = this.error;
                    if (throwable != null) {
                        subscriber.onError(throwable);
                    } else {
                        subscriber.onCompleted();
                    }
                    return true;
                }
            } else {
                Throwable throwable = this.error;
                if (throwable != null) {
                    this.queue.clear();
                    subscriber.onError(throwable);
                    return true;
                }
                if (bl2) {
                    subscriber.onCompleted();
                    return true;
                }
            }
        }
        return false;
    }
}

