/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.OperatorGroupBy$GroupByProducer;
import com.zoyi.rx.internal.operators.OperatorGroupBy$GroupBySubscriber$EvictionAction;
import com.zoyi.rx.internal.operators.OperatorGroupBy$GroupedUnicast;
import com.zoyi.rx.internal.producers.ProducerArbiter;
import com.zoyi.rx.observables.GroupedObservable;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class OperatorGroupBy$GroupBySubscriber<T, K, V>
extends Subscriber<T> {
    final Subscriber<? super GroupedObservable<K, V>> actual;
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Map<Object, OperatorGroupBy$GroupedUnicast<K, V>> groups;
    final Queue<GroupedObservable<K, V>> queue;
    final OperatorGroupBy$GroupByProducer producer;
    final Queue<K> evictedKeys;
    static final Object NULL_KEY = new Object();
    final ProducerArbiter s;
    final AtomicBoolean cancelled;
    final AtomicLong requested;
    final AtomicInteger groupCount;
    Throwable error;
    volatile boolean done;
    final AtomicInteger wip;

    public OperatorGroupBy$GroupBySubscriber(Subscriber<? super GroupedObservable<K, V>> subscriber, Func1<? super T, ? extends K> func1, Func1<? super T, ? extends V> func12, int n2, boolean bl, Func1<Action1<K>, Map<K, Object>> func13) {
        this.actual = subscriber;
        this.keySelector = func1;
        this.valueSelector = func12;
        this.bufferSize = n2;
        this.delayError = bl;
        this.queue = new ConcurrentLinkedQueue<GroupedObservable<K, V>>();
        this.s = new ProducerArbiter();
        this.s.request(n2);
        this.producer = new OperatorGroupBy$GroupByProducer(this);
        this.cancelled = new AtomicBoolean();
        this.requested = new AtomicLong();
        this.groupCount = new AtomicInteger(1);
        this.wip = new AtomicInteger();
        if (func13 == null) {
            this.groups = new ConcurrentHashMap<Object, OperatorGroupBy$GroupedUnicast<K, V>>();
            this.evictedKeys = null;
            return;
        }
        this.evictedKeys = new ConcurrentLinkedQueue<K>();
        this.groups = this.createMap(func13, new OperatorGroupBy$GroupBySubscriber$EvictionAction<K>(this.evictedKeys));
    }

    private Map<Object, OperatorGroupBy$GroupedUnicast<K, V>> createMap(Func1<Action1<K>, Map<K, Object>> func1, Action1<K> action1) {
        return func1.call(action1);
    }

    @Override
    public final void setProducer(Producer producer) {
        this.s.setProducer(producer);
    }

    @Override
    public final void onNext(T object) {
        K k2;
        if (this.done) {
            return;
        }
        Queue<GroupedObservable<K, V>> queue = this.queue;
        Subscriber<? super GroupedObservable<K, V>> subscriber = this.actual;
        try {
            k2 = this.keySelector.call(object);
        }
        catch (Throwable throwable) {
            this.unsubscribe();
            this.errorAll(subscriber, queue, throwable);
            return;
        }
        boolean bl = true;
        Object object2 = k2 != null ? k2 : NULL_KEY;
        OperatorGroupBy$GroupedUnicast<K, Object> operatorGroupBy$GroupedUnicast = this.groups.get(object2);
        if (operatorGroupBy$GroupedUnicast == null) {
            if (!this.cancelled.get()) {
                operatorGroupBy$GroupedUnicast = OperatorGroupBy$GroupedUnicast.createWith(k2, this.bufferSize, this, this.delayError);
                this.groups.put(object2, operatorGroupBy$GroupedUnicast);
                this.groupCount.getAndIncrement();
                bl = false;
                queue.offer(operatorGroupBy$GroupedUnicast);
                this.drain();
            } else {
                return;
            }
        }
        try {
            object = this.valueSelector.call(object);
        }
        catch (Throwable throwable) {
            this.unsubscribe();
            this.errorAll(subscriber, queue, throwable);
            return;
        }
        operatorGroupBy$GroupedUnicast.onNext(object);
        if (this.evictedKeys != null) {
            while ((object = this.evictedKeys.poll()) != null) {
                if ((object = this.groups.get(object)) == null) continue;
                ((OperatorGroupBy$GroupedUnicast)object).onComplete();
            }
        }
        if (bl) {
            this.s.request(1L);
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.done) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.error = throwable;
        this.done = true;
        this.groupCount.decrementAndGet();
        this.drain();
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        for (OperatorGroupBy$GroupedUnicast<K, V> operatorGroupBy$GroupedUnicast : this.groups.values()) {
            operatorGroupBy$GroupedUnicast.onComplete();
        }
        this.groups.clear();
        if (this.evictedKeys != null) {
            this.evictedKeys.clear();
        }
        this.done = true;
        this.groupCount.decrementAndGet();
        this.drain();
    }

    public final void requestMore(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        BackpressureUtils.getAndAddRequest(this.requested, l2);
        this.drain();
    }

    public final void cancel() {
        if (this.cancelled.compareAndSet(false, true) && this.groupCount.decrementAndGet() == 0) {
            this.unsubscribe();
        }
    }

    public final void cancel(K k2) {
        Object object = k2 = k2 != null ? k2 : NULL_KEY;
        if (this.groups.remove(k2) != null && this.groupCount.decrementAndGet() == 0) {
            this.unsubscribe();
        }
    }

    final void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int n2 = 1;
        Queue<GroupedObservable<K, V>> queue = this.queue;
        Subscriber<GroupedObservable<K, V>> subscriber = this.actual;
        do {
            long l2;
            if (this.checkTerminated(this.done, queue.isEmpty(), subscriber, queue)) {
                return;
            }
            long l3 = this.requested.get();
            for (l2 = 0L; l2 != l3; ++l2) {
                boolean bl;
                boolean bl2 = this.done;
                GroupedObservable<K, V> groupedObservable = queue.poll();
                boolean bl3 = bl = groupedObservable == null;
                if (this.checkTerminated(bl2, bl, subscriber, queue)) {
                    return;
                }
                if (bl) break;
                subscriber.onNext(groupedObservable);
            }
            if (l2 == 0L) continue;
            if (l3 != Long.MAX_VALUE) {
                BackpressureUtils.produced(this.requested, l2);
            }
            this.s.request(l2);
        } while ((n2 = this.wip.addAndGet(-n2)) != 0);
    }

    final void errorAll(Subscriber<? super GroupedObservable<K, V>> subscriber, Queue<?> object, Throwable throwable) {
        object.clear();
        object = new ArrayList<OperatorGroupBy$GroupedUnicast<K, V>>(this.groups.values());
        this.groups.clear();
        if (this.evictedKeys != null) {
            this.evictedKeys.clear();
        }
        object = object.iterator();
        while (object.hasNext()) {
            OperatorGroupBy$GroupedUnicast operatorGroupBy$GroupedUnicast = (OperatorGroupBy$GroupedUnicast)object.next();
            operatorGroupBy$GroupedUnicast.onError(throwable);
        }
        subscriber.onError(throwable);
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<? super GroupedObservable<K, V>> subscriber, Queue<?> queue) {
        if (bl) {
            Throwable throwable = this.error;
            if (throwable != null) {
                this.errorAll(subscriber, queue, throwable);
                return true;
            }
            if (bl2) {
                this.actual.onCompleted();
                return true;
            }
        }
        return false;
    }
}

