/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.plugins.RxJavaHooks;

final class OperatorCast$CastSubscriber<T, R>
extends Subscriber<T> {
    final Subscriber<? super R> actual;
    final Class<R> castClass;
    boolean done;

    public OperatorCast$CastSubscriber(Subscriber<? super R> subscriber, Class<R> clazz) {
        this.actual = subscriber;
        this.castClass = clazz;
    }

    @Override
    public final void onNext(T t2) {
        R r2;
        try {
            r2 = this.castClass.cast(t2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwIfFatal(throwable);
            this.unsubscribe();
            this.onError(OnErrorThrowable.addValueAsLastCause(throwable2, t2));
            return;
        }
        this.actual.onNext(r2);
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.done) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.done = true;
        this.actual.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        this.actual.onCompleted();
    }

    @Override
    public final void setProducer(Producer producer) {
        this.actual.setProducer(producer);
    }
}

