/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.internal.operators.OnSubscribeRefCount$1;
import com.zoyi.rx.internal.operators.OnSubscribeRefCount$2;
import com.zoyi.rx.internal.operators.OnSubscribeRefCount$3;
import com.zoyi.rx.observables.ConnectableObservable;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class OnSubscribeRefCount<T>
implements Observable$OnSubscribe<T> {
    private final ConnectableObservable<? extends T> source;
    volatile CompositeSubscription baseSubscription = new CompositeSubscription();
    final AtomicInteger subscriptionCount = new AtomicInteger(0);
    final ReentrantLock lock = new ReentrantLock();

    public OnSubscribeRefCount(ConnectableObservable<? extends T> connectableObservable) {
        this.source = connectableObservable;
    }

    @Override
    public final void call(Subscriber<? super T> subscriber) {
        block8: {
            this.lock.lock();
            if (this.subscriptionCount.incrementAndGet() == 1) {
                block7: {
                    AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                    try {
                        this.source.connect(this.onSubscribe(subscriber, atomicBoolean));
                        if (!atomicBoolean.get()) break block7;
                        this.lock.unlock();
                        break block8;
                    }
                    catch (Throwable throwable) {
                        if (atomicBoolean.get()) {
                            this.lock.unlock();
                        }
                        throw throwable;
                    }
                }
                return;
            }
            try {
                this.doSubscribe(subscriber, this.baseSubscription);
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Action1<Subscription> onSubscribe(Subscriber<? super T> subscriber, AtomicBoolean atomicBoolean) {
        return new OnSubscribeRefCount$1(this, subscriber, atomicBoolean);
    }

    final void doSubscribe(Subscriber<? super T> subscriber, CompositeSubscription compositeSubscription) {
        subscriber.add(this.disconnect(compositeSubscription));
        this.source.unsafeSubscribe(new OnSubscribeRefCount$2(this, subscriber, subscriber, compositeSubscription));
    }

    private Subscription disconnect(CompositeSubscription compositeSubscription) {
        return Subscriptions.create(new OnSubscribeRefCount$3(this, compositeSubscription));
    }
}

