/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.NoSuchElementException;

final class OnSubscribeReduce$ReduceSubscriber<T>
extends Subscriber<T> {
    final Subscriber<? super T> actual;
    final Func2<T, T, T> reducer;
    T value;
    static final Object EMPTY = new Object();
    boolean done;

    public OnSubscribeReduce$ReduceSubscriber(Subscriber<? super T> subscriber, Func2<T, T, T> func2) {
        this.actual = subscriber;
        this.reducer = func2;
        this.value = EMPTY;
        this.request(0L);
    }

    @Override
    public final void onNext(T object) {
        if (this.done) {
            return;
        }
        T t2 = this.value;
        if (t2 == EMPTY) {
            this.value = object;
            return;
        }
        try {
            this.value = this.reducer.call(t2, object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            Exceptions.throwIfFatal(throwable);
            this.unsubscribe();
            this.onError((Throwable)object);
            return;
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (!this.done) {
            this.done = true;
            this.actual.onError(throwable);
            return;
        }
        RxJavaHooks.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        T t2 = this.value;
        if (t2 != EMPTY) {
            this.actual.onNext(t2);
            this.actual.onCompleted();
            return;
        }
        this.actual.onError(new NoSuchElementException());
    }

    final void downstreamRequest(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        if (l2 != 0L) {
            this.request(Long.MAX_VALUE);
        }
    }
}

