/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Arrays;

final class OnSubscribeDoOnEach$DoOnEachSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> subscriber;
    private final Observer<? super T> doOnEachObserver;
    private boolean done;

    OnSubscribeDoOnEach$DoOnEachSubscriber(Subscriber<? super T> subscriber, Observer<? super T> observer) {
        super(subscriber);
        this.subscriber = subscriber;
        this.doOnEachObserver = observer;
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        try {
            this.doOnEachObserver.onCompleted();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwOrReport(throwable, this);
            return;
        }
        this.done = true;
        this.subscriber.onCompleted();
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.done) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.done = true;
        try {
            this.doOnEachObserver.onError(throwable);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Exceptions.throwIfFatal(throwable2);
            this.subscriber.onError(new CompositeException(Arrays.asList(throwable, throwable3)));
            return;
        }
        this.subscriber.onError(throwable);
    }

    @Override
    public final void onNext(T t2) {
        if (this.done) {
            return;
        }
        try {
            this.doOnEachObserver.onNext(t2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwOrReport(throwable, this, t2);
            return;
        }
        this.subscriber.onNext(t2);
    }
}

