/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.observables.ConnectableObservable;
import com.zoyi.rx.observers.Subscribers;
import java.util.concurrent.atomic.AtomicInteger;

public final class OnSubscribeAutoConnect<T>
extends AtomicInteger
implements Observable$OnSubscribe<T> {
    final ConnectableObservable<? extends T> source;
    final int numberOfSubscribers;
    final Action1<? super Subscription> connection;

    public OnSubscribeAutoConnect(ConnectableObservable<? extends T> connectableObservable, int n2, Action1<? super Subscription> action1) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("numberOfSubscribers > 0 required");
        }
        this.source = connectableObservable;
        this.numberOfSubscribers = n2;
        this.connection = action1;
    }

    @Override
    public final void call(Subscriber<? super T> subscriber) {
        this.source.unsafeSubscribe(Subscribers.wrap(subscriber));
        if (this.incrementAndGet() == this.numberOfSubscribers) {
            this.source.connect(this.connection);
        }
    }
}

