/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.Completable$OnSubscribe;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeMergeIterable$1;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableOnSubscribeMergeIterable
implements Completable$OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeIterable(Iterable<? extends Completable> iterable) {
        this.sources = iterable;
    }

    @Override
    public final void call(CompletableSubscriber completableSubscriber) {
        Object object;
        CompositeSubscription compositeSubscription = new CompositeSubscription();
        completableSubscriber.onSubscribe(compositeSubscription);
        try {
            object = this.sources.iterator();
        }
        catch (Throwable throwable) {
            completableSubscriber.onError(throwable);
            return;
        }
        if (object == null) {
            completableSubscriber.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger(1);
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        while (true) {
            Completable completable;
            boolean bl;
            if (compositeSubscription.isUnsubscribed()) {
                return;
            }
            try {
                bl = object.hasNext();
            }
            catch (Throwable throwable) {
                compositeSubscription.unsubscribe();
                if (atomicBoolean.compareAndSet(false, true)) {
                    completableSubscriber.onError(throwable);
                    return;
                }
                RxJavaHooks.onError(throwable);
                return;
            }
            if (!bl) break;
            if (compositeSubscription.isUnsubscribed()) {
                return;
            }
            try {
                completable = object.next();
            }
            catch (Throwable throwable) {
                compositeSubscription.unsubscribe();
                if (atomicBoolean.compareAndSet(false, true)) {
                    completableSubscriber.onError(throwable);
                    return;
                }
                RxJavaHooks.onError(throwable);
                return;
            }
            if (compositeSubscription.isUnsubscribed()) {
                return;
            }
            if (completable == null) {
                compositeSubscription.unsubscribe();
                object = new NullPointerException("A completable source is null");
                if (atomicBoolean.compareAndSet(false, true)) {
                    completableSubscriber.onError((Throwable)object);
                    return;
                }
                RxJavaHooks.onError((Throwable)object);
                return;
            }
            atomicInteger.getAndIncrement();
            completable.unsafeSubscribe(new CompletableOnSubscribeMergeIterable$1(this, compositeSubscription, atomicBoolean, completableSubscriber, atomicInteger));
        }
        if (atomicInteger.decrementAndGet() == 0 && atomicBoolean.compareAndSet(false, true)) {
            completableSubscriber.onCompleted();
        }
    }
}

