/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.exceptions;

import com.zoyi.rx.Observer;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.OnCompletedFailedException;
import com.zoyi.rx.exceptions.OnErrorFailedException;
import com.zoyi.rx.exceptions.OnErrorNotImplementedException;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    public static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void throwIfFatal(Throwable throwable) {
        if (throwable instanceof OnErrorNotImplementedException) {
            throw (OnErrorNotImplementedException)throwable;
        }
        if (throwable instanceof OnErrorFailedException) {
            throw (OnErrorFailedException)throwable;
        }
        if (throwable instanceof OnCompletedFailedException) {
            throw (OnCompletedFailedException)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof LinkageError) {
            throw (LinkageError)throwable;
        }
    }

    public static void addCause(Throwable throwable, Throwable throwable2) {
        HashSet<Throwable> hashSet = new HashSet<Throwable>();
        int n2 = 0;
        while (throwable.getCause() != null) {
            if (n2++ >= 25) {
                return;
            }
            if (hashSet.contains((throwable = throwable.getCause()).getCause())) break;
            hashSet.add(throwable.getCause());
        }
        try {
            throwable.initCause(throwable2);
            return;
        }
        catch (Throwable throwable3) {
            return;
        }
    }

    public static Throwable getFinalCause(Throwable throwable) {
        int n2 = 0;
        while (throwable.getCause() != null) {
            if (n2++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static void throwIfAny(List<? extends Throwable> object) {
        if (object != null && !object.isEmpty()) {
            if (object.size() == 1) {
                if ((object = object.get(0)) instanceof RuntimeException) {
                    throw (RuntimeException)object;
                }
                if (object instanceof Error) {
                    throw (Error)object;
                }
                throw new RuntimeException((Throwable)object);
            }
            throw new CompositeException((Collection<? extends Throwable>)object);
        }
    }

    @Experimental
    public static void throwOrReport(Throwable throwable, Observer<?> observer, Object object) {
        Exceptions.throwIfFatal(throwable);
        observer.onError(OnErrorThrowable.addValueAsLastCause(throwable, object));
    }

    @Experimental
    public static void throwOrReport(Throwable throwable, SingleSubscriber<?> singleSubscriber, Object object) {
        Exceptions.throwIfFatal(throwable);
        singleSubscriber.onError(OnErrorThrowable.addValueAsLastCause(throwable, object));
    }

    @Experimental
    public static void throwOrReport(Throwable throwable, Observer<?> observer) {
        Exceptions.throwIfFatal(throwable);
        observer.onError(throwable);
    }

    @Experimental
    public static void throwOrReport(Throwable throwable, SingleSubscriber<?> singleSubscriber) {
        Exceptions.throwIfFatal(throwable);
        singleSubscriber.onError(throwable);
    }
}

