/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.android;

import android.os.Looper;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.MainThreadSubscription$1;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MainThreadSubscription
implements Subscription {
    private final AtomicBoolean unsubscribed = new AtomicBoolean();

    public static void verifyMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("Expected to be called on the main thread but was " + Thread.currentThread().getName());
        }
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.unsubscribed.get();
    }

    @Override
    public final void unsubscribe() {
        if (this.unsubscribed.compareAndSet(false, true)) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.onUnsubscribe();
                return;
            }
            AndroidSchedulers.mainThread().createWorker().schedule(new MainThreadSubscription$1(this));
        }
    }

    protected abstract void onUnsubscribe();
}

