/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okio;

import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.ForwardingSource;
import com.zoyi.retrofit2.okio.Segment;
import com.zoyi.retrofit2.okio.Source;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    private HashingSource(Source source, String string) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        long l3 = super.read(buffer, l2);
        if (l3 != -1L) {
            long l4;
            long l5 = buffer.size - l3;
            Segment segment = buffer.head;
            for (l4 = buffer.size; l4 > buffer.size - l3; l4 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
            while (l4 < buffer.size) {
                int n2 = (int)((long)segment.pos + l5 - l4);
                this.messageDigest.update(segment.data, n2, segment.limit - n2);
                l5 = l4 += (long)(segment.limit - segment.pos);
            }
        }
        return l3;
    }

    public final ByteString hash() {
        byte[] byArray = this.messageDigest.digest();
        return ByteString.of(byArray);
    }
}

