/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.tls;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.tls.DistinguishedNameParser;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    private OkHostnameVerifier() {
    }

    @Override
    public final boolean verify(String string, SSLSession certificateArray) {
        try {
            certificateArray = certificateArray.getPeerCertificates();
            return this.verify(string, (X509Certificate)certificateArray[0]);
        }
        catch (SSLException sSLException) {
            return false;
        }
    }

    public final boolean verify(String string, X509Certificate x509Certificate) {
        if (Util.verifyAsIpAddress(string)) {
            return this.verifyIpAddress(string, x509Certificate);
        }
        return this.verifyHostname(string, x509Certificate);
    }

    private boolean verifyIpAddress(String string, X509Certificate object) {
        object = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 7);
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase((String)object.get(i2))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostname(String string, X509Certificate x509Certificate) {
        X500Principal x500Principal;
        String string2;
        string = string.toLowerCase(Locale.US);
        boolean bl = false;
        List<String> list = OkHostnameVerifier.getSubjectAltNames(x509Certificate, 2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            bl = true;
            if (!this.verifyHostname(string, list.get(i2))) continue;
            return true;
        }
        if (!bl && (string2 = new DistinguishedNameParser(x500Principal = x509Certificate.getSubjectX500Principal()).findMostSpecific("cn")) != null) {
            return this.verifyHostname(string, string2);
        }
        return false;
    }

    public static List<String> allSubjectAltNames(X509Certificate object) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 7);
        object = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + object.size());
        arrayList.addAll(list);
        arrayList.addAll((Collection<String>)object);
        return arrayList;
    }

    private static List<String> getSubjectAltNames(X509Certificate iterator, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames();
            if (iterator == null) {
                return Collections.emptyList();
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Integer n3;
                Object object = iterator.next();
                if ((object = (List)object) == null || object.size() < 2 || (n3 = (Integer)object.get(0)) == null || n3 != n2 || (object = (String)object.get(1)) == null) continue;
                arrayList.add((String)object);
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    private boolean verifyHostname(String string, String string2) {
        if (string == null || string.length() == 0 || string.startsWith(".") || string.endsWith("..")) {
            return false;
        }
        if (string2 == null || string2.length() == 0 || string2.startsWith(".") || string2.endsWith("..")) {
            return false;
        }
        if (!string.endsWith(".")) {
            string = string + '.';
        }
        if (!string2.endsWith(".")) {
            string2 = string2 + '.';
        }
        if (!(string2 = string2.toLowerCase(Locale.US)).contains("*")) {
            return string.equals(string2);
        }
        if (!string2.startsWith("*.") || string2.indexOf(42, 1) != -1) {
            return false;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        if ("*.".equals(string2)) {
            return false;
        }
        if (!string.endsWith(string2 = string2.substring(1))) {
            return false;
        }
        int n2 = string.length() - string2.length();
        return n2 <= 0 || string.lastIndexOf(46, n2 - 1) == -1;
    }
}

