/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.Challenge;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.http.HeaderParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class OkHeaders {
    static final String PREFIX = Platform.get().getPrefix();
    public static final String SENT_MILLIS = PREFIX + "-Sent-Millis";
    public static final String RECEIVED_MILLIS = PREFIX + "-Received-Millis";
    public static final String SELECTED_PROTOCOL = PREFIX + "-Selected-Protocol";
    public static final String RESPONSE_SOURCE = PREFIX + "-Response-Source";

    private OkHeaders() {
    }

    public static long contentLength(Request request) {
        return OkHeaders.contentLength(request.headers());
    }

    public static long contentLength(Response response) {
        return OkHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return OkHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response object, Headers headers, Request request) {
        for (String string : OkHeaders.varyFields((Response)object)) {
            if (Util.equal(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return OkHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return OkHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return OkHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!"Vary".equalsIgnoreCase(headers.name(i2))) continue;
            String[] stringArray = headers.value(i2);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string : stringArray.split(",")) {
                set.add(string.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response object) {
        Headers headers = ((Response)object).networkResponse().request().headers();
        object = ((Response)object).headers();
        return OkHeaders.varyHeaders(headers, (Headers)object);
    }

    public static Headers varyHeaders(Headers headers, Headers object) {
        if ((object = OkHeaders.varyFields((Headers)object)).isEmpty()) {
            return new Headers$Builder().build();
        }
        Headers$Builder headers$Builder = new Headers$Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = headers.name(i2);
            if (!object.contains(string)) continue;
            headers$Builder.add(string, headers.value(i2));
        }
        return headers$Builder.build();
    }

    static boolean isEndToEnd(String string) {
        return !"Connection".equalsIgnoreCase(string) && !"Keep-Alive".equalsIgnoreCase(string) && !"Proxy-Authenticate".equalsIgnoreCase(string) && !"Proxy-Authorization".equalsIgnoreCase(string) && !"TE".equalsIgnoreCase(string) && !"Trailers".equalsIgnoreCase(string) && !"Transfer-Encoding".equalsIgnoreCase(string) && !"Upgrade".equalsIgnoreCase(string);
    }

    public static List<Challenge> parseChallenges(Headers headers, String string) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        int n2 = headers.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase(headers.name(i2))) continue;
            String string2 = headers.value(i2);
            int n3 = 0;
            while (n3 < string2.length()) {
                int n4 = n3;
                n3 = HeaderParser.skipUntil(string2, n3, " ");
                String string3 = string2.substring(n4, n3).trim();
                if (!string2.regionMatches(true, n3 = HeaderParser.skipWhitespace(string2, n3), "realm=\"", 0, 7)) continue block0;
                int n5 = n3 += 7;
                n3 = HeaderParser.skipUntil(string2, n3, "\"");
                String string4 = string2.substring(n5, n3);
                ++n3;
                n3 = HeaderParser.skipUntil(string2, n3, ",");
                ++n3;
                n3 = HeaderParser.skipWhitespace(string2, n3);
                arrayList.add(new Challenge(string3, string4));
            }
        }
        return arrayList;
    }
}

