/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.Address;
import com.zoyi.retrofit2.okhttp3.CertificatePinner;
import com.zoyi.retrofit2.okhttp3.Connection;
import com.zoyi.retrofit2.okhttp3.Cookie;
import com.zoyi.retrofit2.okhttp3.CookieJar;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.OkHttpClient;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Request$Builder;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.Response$Builder;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import com.zoyi.retrofit2.okhttp3.Route;
import com.zoyi.retrofit2.okhttp3.internal.Internal;
import com.zoyi.retrofit2.okhttp3.internal.InternalCache;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.Version;
import com.zoyi.retrofit2.okhttp3.internal.http.CacheRequest;
import com.zoyi.retrofit2.okhttp3.internal.http.CacheStrategy;
import com.zoyi.retrofit2.okhttp3.internal.http.CacheStrategy$Factory;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine$1;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine$2;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine$NetworkInterceptorChain;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpMethod;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpStream;
import com.zoyi.retrofit2.okhttp3.internal.http.OkHeaders;
import com.zoyi.retrofit2.okhttp3.internal.http.RealResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.http.RequestException;
import com.zoyi.retrofit2.okhttp3.internal.http.RetryableSink;
import com.zoyi.retrofit2.okhttp3.internal.http.RouteException;
import com.zoyi.retrofit2.okhttp3.internal.http.StreamAllocation;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.GzipSource;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Source;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public final class HttpEngine {
    public static final int MAX_FOLLOW_UPS = 20;
    private static final ResponseBody EMPTY_BODY = new HttpEngine$1();
    final OkHttpClient client;
    public final StreamAllocation streamAllocation;
    private final Response priorResponse;
    private HttpStream httpStream;
    long sentRequestMillis = -1L;
    private boolean transparentGzip;
    public final boolean bufferRequestBody;
    private final Request userRequest;
    private Request networkRequest;
    private Response cacheResponse;
    private Response userResponse;
    private Sink requestBodyOut;
    private BufferedSink bufferedRequestBody;
    private final boolean callerWritesRequestBody;
    private final boolean forWebSocket;
    private CacheRequest storeRequest;
    private CacheStrategy cacheStrategy;

    public HttpEngine(OkHttpClient okHttpClient, Request request, boolean bl, boolean bl2, boolean bl3, StreamAllocation streamAllocation, RetryableSink retryableSink, Response response) {
        this.client = okHttpClient;
        this.userRequest = request;
        this.bufferRequestBody = bl;
        this.callerWritesRequestBody = bl2;
        this.forWebSocket = bl3;
        this.streamAllocation = streamAllocation != null ? streamAllocation : new StreamAllocation(okHttpClient.connectionPool(), HttpEngine.createAddress(okHttpClient, request));
        this.requestBodyOut = retryableSink;
        this.priorResponse = response;
    }

    public final void sendRequest() throws RequestException, RouteException, IOException {
        block14: {
            if (this.cacheStrategy != null) {
                return;
            }
            if (this.httpStream != null) {
                throw new IllegalStateException();
            }
            Request request = this.networkRequest(this.userRequest);
            InternalCache internalCache = Internal.instance.internalCache(this.client);
            Response response = internalCache != null ? internalCache.get(request) : null;
            long l2 = System.currentTimeMillis();
            this.cacheStrategy = new CacheStrategy$Factory(l2, request, response).get();
            this.networkRequest = this.cacheStrategy.networkRequest;
            this.cacheResponse = this.cacheStrategy.cacheResponse;
            if (internalCache != null) {
                internalCache.trackResponse(this.cacheStrategy);
            }
            if (response != null && this.cacheResponse == null) {
                Util.closeQuietly(response.body());
            }
            if (this.networkRequest == null && this.cacheResponse == null) {
                this.userResponse = new Response$Builder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(EMPTY_BODY).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
                return;
            }
            if (this.networkRequest == null) {
                this.userResponse = this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).build();
                this.userResponse = this.unzip(this.userResponse);
                return;
            }
            try {
                this.httpStream = this.connect();
                this.httpStream.setHttpEngine(this);
                if (this.writeRequestHeadersEagerly()) {
                    long l3 = OkHeaders.contentLength(request);
                    if (this.bufferRequestBody) {
                        if (l3 > Integer.MAX_VALUE) {
                            throw new IllegalStateException("Use setFixedLengthStreamingMode() or setChunkedStreamingMode() for requests larger than 2 GiB.");
                        }
                        if (l3 != -1L) {
                            this.httpStream.writeRequestHeaders(this.networkRequest);
                            this.requestBodyOut = new RetryableSink((int)l3);
                        } else {
                            this.requestBodyOut = new RetryableSink();
                        }
                        break block14;
                    }
                    this.httpStream.writeRequestHeaders(this.networkRequest);
                    this.requestBodyOut = this.httpStream.createRequestBody(this.networkRequest, l3);
                }
                return;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    Util.closeQuietly(response.body());
                }
                throw throwable;
            }
        }
    }

    private boolean writeRequestHeadersEagerly() {
        return this.callerWritesRequestBody && this.permitsRequestBody(this.networkRequest) && this.requestBodyOut == null;
    }

    private HttpStream connect() throws RouteException, RequestException, IOException {
        boolean bl = !this.networkRequest.method().equals("GET");
        return this.streamAllocation.newStream(this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis(), this.client.retryOnConnectionFailure(), bl);
    }

    private static Response stripBody(Response response) {
        if (response != null && response.body() != null) {
            return response.newBuilder().body(null).build();
        }
        return response;
    }

    public final void writingRequestHeaders() {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        this.sentRequestMillis = System.currentTimeMillis();
    }

    final boolean permitsRequestBody(Request request) {
        return HttpMethod.permitsRequestBody(request.method());
    }

    public final Sink getRequestBody() {
        if (this.cacheStrategy == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public final BufferedSink getBufferedRequestBody() {
        Sink sink = this.bufferedRequestBody;
        if (sink != null) {
            return sink;
        }
        sink = this.getRequestBody();
        if (sink != null) {
            this.bufferedRequestBody = Okio.buffer(sink);
            return this.bufferedRequestBody;
        }
        return null;
    }

    public final boolean hasResponse() {
        return this.userResponse != null;
    }

    public final Request getRequest() {
        return this.userRequest;
    }

    public final Response getResponse() {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        return this.userResponse;
    }

    public final Connection getConnection() {
        return this.streamAllocation.connection();
    }

    public final HttpEngine recover(IOException object, boolean bl, Sink sink) {
        this.streamAllocation.streamFailed((IOException)object);
        if (!this.client.retryOnConnectionFailure()) {
            return null;
        }
        if (sink != null && !(sink instanceof RetryableSink)) {
            return null;
        }
        if (!this.isRecoverable((IOException)object, bl)) {
            return null;
        }
        if (!this.streamAllocation.hasMoreRoutes()) {
            return null;
        }
        object = this.close();
        return new HttpEngine(this.client, this.userRequest, this.bufferRequestBody, this.callerWritesRequestBody, this.forWebSocket, (StreamAllocation)object, (RetryableSink)sink, this.priorResponse);
    }

    public final HttpEngine recover(IOException iOException, boolean bl) {
        return this.recover(iOException, bl, this.requestBodyOut);
    }

    private boolean isRecoverable(IOException iOException, boolean bl) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && bl;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private void maybeCache() throws IOException {
        InternalCache internalCache = Internal.instance.internalCache(this.client);
        if (internalCache == null) {
            return;
        }
        if (!CacheStrategy.isCacheable(this.userResponse, this.networkRequest)) {
            if (HttpMethod.invalidatesCache(this.networkRequest.method())) {
                try {
                    internalCache.remove(this.networkRequest);
                    return;
                }
                catch (IOException iOException) {}
            }
            return;
        }
        this.storeRequest = internalCache.put(this.userResponse);
    }

    public final void releaseStreamAllocation() throws IOException {
        this.streamAllocation.release();
    }

    public final void cancel() {
        this.streamAllocation.cancel();
    }

    public final StreamAllocation close() {
        if (this.bufferedRequestBody != null) {
            Util.closeQuietly(this.bufferedRequestBody);
        } else if (this.requestBodyOut != null) {
            Util.closeQuietly(this.requestBodyOut);
        }
        if (this.userResponse != null) {
            Util.closeQuietly(this.userResponse.body());
        } else {
            this.streamAllocation.streamFailed(null);
        }
        return this.streamAllocation;
    }

    private Response unzip(Response response) throws IOException {
        if (!this.transparentGzip || !"gzip".equalsIgnoreCase(this.userResponse.header("Content-Encoding"))) {
            return response;
        }
        if (response.body() == null) {
            return response;
        }
        GzipSource gzipSource = new GzipSource(response.body().source());
        Headers headers = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
        return response.newBuilder().headers(headers).body(new RealResponseBody(headers, Okio.buffer(gzipSource))).build();
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        return OkHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    private Request networkRequest(Request request) throws IOException {
        List<Cookie> list;
        Request$Builder request$Builder = request.newBuilder();
        if (request.header("Host") == null) {
            request$Builder.header("Host", Util.hostHeader(request.url(), false));
        }
        if (request.header("Connection") == null) {
            request$Builder.header("Connection", "Keep-Alive");
        }
        if (request.header("Accept-Encoding") == null) {
            this.transparentGzip = true;
            request$Builder.header("Accept-Encoding", "gzip");
        }
        if (!(list = this.client.cookieJar().loadForRequest(request.url())).isEmpty()) {
            request$Builder.header("Cookie", this.cookieHeader(list));
        }
        if (request.header("User-Agent") == null) {
            request$Builder.header("User-Agent", Version.userAgent());
        }
        return request$Builder.build();
    }

    private String cookieHeader(List<Cookie> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append("; ");
            }
            Cookie cookie = list.get(i2);
            stringBuilder.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    public final void readResponse() throws IOException {
        block15: {
            if (this.userResponse != null) {
                return;
            }
            if (this.networkRequest == null && this.cacheResponse == null) {
                throw new IllegalStateException("call sendRequest() first!");
            }
            if (this.networkRequest == null) {
                return;
            }
            if (!this.forWebSocket) break block15;
            this.httpStream.writeRequestHeaders(this.networkRequest);
            ** GOTO lbl29
        }
        if (!this.callerWritesRequestBody) {
            var1_1 = new HttpEngine$NetworkInterceptorChain(this, 0, this.networkRequest, this.streamAllocation.connection()).proceed(this.networkRequest);
        } else {
            if (this.bufferedRequestBody != null && this.bufferedRequestBody.buffer().size() > 0L) {
                this.bufferedRequestBody.emit();
            }
            if (this.sentRequestMillis == -1L) {
                if (OkHeaders.contentLength(this.networkRequest) == -1L && this.requestBodyOut instanceof RetryableSink) {
                    var2_2 = ((RetryableSink)this.requestBodyOut).contentLength();
                    this.networkRequest = this.networkRequest.newBuilder().header("Content-Length", Long.toString(var2_2)).build();
                }
                this.httpStream.writeRequestHeaders(this.networkRequest);
            }
            if (this.requestBodyOut != null) {
                if (this.bufferedRequestBody != null) {
                    this.bufferedRequestBody.close();
                } else {
                    this.requestBodyOut.close();
                }
                if (this.requestBodyOut instanceof RetryableSink) {
                    this.httpStream.writeRequestBody((RetryableSink)this.requestBodyOut);
                }
            }
lbl29:
            // 6 sources

            var1_1 = this.readNetworkResponse();
        }
        this.receiveHeaders(var1_1.headers());
        if (this.cacheResponse != null) {
            if (HttpEngine.validate(this.cacheResponse, var1_1)) {
                this.userResponse = this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).headers(HttpEngine.combine(this.cacheResponse.headers(), var1_1.headers())).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody(var1_1)).build();
                var1_1.body().close();
                this.releaseStreamAllocation();
                var2_3 = Internal.instance.internalCache(this.client);
                var2_3.trackConditionalCacheHit();
                var2_3.update(this.cacheResponse, this.userResponse);
                this.userResponse = this.unzip(this.userResponse);
                return;
            }
            Util.closeQuietly(this.cacheResponse.body());
        }
        this.userResponse = var1_1.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody(var1_1)).build();
        if (HttpEngine.hasBody(this.userResponse)) {
            this.maybeCache();
            this.userResponse = this.unzip(this.cacheWritingResponse(this.storeRequest, this.userResponse));
        }
    }

    private Response readNetworkResponse() throws IOException {
        this.httpStream.finishRequest();
        Response response = this.httpStream.readResponseHeaders().request(this.networkRequest).handshake(this.streamAllocation.connection().handshake()).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
        if (!this.forWebSocket || response.code() != 101) {
            response = response.newBuilder().body(this.httpStream.openResponseBody(response)).build();
        }
        if ("close".equalsIgnoreCase(response.request().header("Connection")) || "close".equalsIgnoreCase(response.header("Connection"))) {
            this.streamAllocation.noNewStreams();
        }
        return response;
    }

    private Response cacheWritingResponse(CacheRequest object, Response response) throws IOException {
        if (object == null) {
            return response;
        }
        Sink sink = object.body();
        if (sink == null) {
            return response;
        }
        BufferedSource bufferedSource = response.body().source();
        sink = Okio.buffer(sink);
        object = new HttpEngine$2(this, bufferedSource, (CacheRequest)object, (BufferedSink)sink);
        return response.newBuilder().body(new RealResponseBody(response.headers(), Okio.buffer((Source)object))).build();
    }

    private static boolean validate(Response object, Response object2) {
        if (((Response)object2).code() == 304) {
            return true;
        }
        return (object = ((Response)object).headers().getDate("Last-Modified")) != null && (object2 = ((Response)object2).headers().getDate("Last-Modified")) != null && ((Date)object2).getTime() < ((Date)object).getTime();
    }

    private static Headers combine(Headers headers, Headers headers2) throws IOException {
        String string;
        int n2;
        Headers$Builder headers$Builder = new Headers$Builder();
        int n3 = headers.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = headers.name(n2);
            String string2 = headers.value(n2);
            if ("Warning".equalsIgnoreCase(string) && string2.startsWith("1") || OkHeaders.isEndToEnd(string) && headers2.get(string) != null) continue;
            Internal.instance.addLenient(headers$Builder, string, string2);
        }
        n3 = headers2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = headers2.name(n2);
            if ("Content-Length".equalsIgnoreCase(string) || !OkHeaders.isEndToEnd(string)) continue;
            Internal.instance.addLenient(headers$Builder, string, headers2.value(n2));
        }
        return headers$Builder.build();
    }

    public final void receiveHeaders(Headers list) throws IOException {
        if (this.client.cookieJar() == CookieJar.NO_COOKIES) {
            return;
        }
        list = Cookie.parseAll(this.userRequest.url(), (Headers)((Object)list));
        if (list.isEmpty()) {
            return;
        }
        this.client.cookieJar().saveFromResponse(this.userRequest.url(), list);
    }

    public final Request followUpRequest() throws IOException {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        Object object = this.streamAllocation.connection();
        object = object != null ? object.route() : null;
        int n2 = this.userResponse.code();
        String string = this.userRequest.method();
        switch (n2) {
            case 407: {
                Proxy proxy = object != null ? ((Route)object).proxy() : this.client.proxy();
                if (proxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate((Route)object, this.userResponse);
            }
            case 401: {
                return this.client.authenticator().authenticate((Route)object, this.userResponse);
            }
            case 307: 
            case 308: {
                if (!string.equals("GET") && !string.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.followRedirects()) {
                    return null;
                }
                object = this.userResponse.header("Location");
                if (object == null) {
                    return null;
                }
                object = this.userRequest.url().resolve((String)object);
                if (object == null) {
                    return null;
                }
                boolean bl = ((HttpUrl)object).scheme().equals(this.userRequest.url().scheme());
                n2 = bl ? 1 : 0;
                if (!bl && !this.client.followSslRedirects()) {
                    return null;
                }
                Request$Builder request$Builder = this.userRequest.newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    if (HttpMethod.redirectsToGet(string)) {
                        request$Builder.method("GET", null);
                    } else {
                        request$Builder.method(string, null);
                    }
                    request$Builder.removeHeader("Transfer-Encoding");
                    request$Builder.removeHeader("Content-Length");
                    request$Builder.removeHeader("Content-Type");
                }
                if (!this.sameConnection((HttpUrl)object)) {
                    request$Builder.removeHeader("Authorization");
                }
                return request$Builder.url((HttpUrl)object).build();
            }
            case 408: {
                boolean bl;
                boolean bl2 = bl = this.requestBodyOut == null || this.requestBodyOut instanceof RetryableSink;
                if (this.callerWritesRequestBody && !bl) {
                    return null;
                }
                return this.userRequest;
            }
        }
        return null;
    }

    public final boolean sameConnection(HttpUrl httpUrl) {
        HttpUrl httpUrl2 = this.userRequest.url();
        return httpUrl2.host().equals(httpUrl.host()) && httpUrl2.port() == httpUrl.port() && httpUrl2.scheme().equals(httpUrl.scheme());
    }

    private static Address createAddress(OkHttpClient okHttpClient, Request request) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (request.isHttps()) {
            sSLSocketFactory = okHttpClient.sslSocketFactory();
            hostnameVerifier = okHttpClient.hostnameVerifier();
            certificatePinner = okHttpClient.certificatePinner();
        }
        return new Address(request.url().host(), request.url().port(), okHttpClient.dns(), okHttpClient.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, okHttpClient.proxyAuthenticator(), okHttpClient.proxy(), okHttpClient.protocols(), okHttpClient.connectionSpecs(), okHttpClient.proxySelector());
    }

    static /* synthetic */ HttpStream access$000(HttpEngine httpEngine) {
        return httpEngine.httpStream;
    }

    static /* synthetic */ Request access$102(HttpEngine httpEngine, Request request) {
        httpEngine.networkRequest = request;
        return httpEngine.networkRequest;
    }

    static /* synthetic */ Response access$200(HttpEngine httpEngine) throws IOException {
        return httpEngine.readNetworkResponse();
    }
}

