/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpDate$1;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class HttpDate {
    public static final long MAX_DATE = 253402300799999L;
    private static final ThreadLocal<DateFormat> STANDARD_DATE_FORMAT = new HttpDate$1();
    private static final String[] BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z", "EEE MMM d yyyy HH:mm:ss z"};
    private static final DateFormat[] BROWSER_COMPATIBLE_DATE_FORMATS = new DateFormat[BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS.length];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String string) {
        if (string.length() == 0) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Cloneable cloneable = STANDARD_DATE_FORMAT.get().parse(string, parsePosition);
        if (parsePosition.getIndex() == string.length()) {
            return cloneable;
        }
        String[] stringArray = BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS;
        synchronized (BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS) {
            int n2 = BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                cloneable = BROWSER_COMPATIBLE_DATE_FORMATS[i2];
                if (cloneable == null) {
                    cloneable = new SimpleDateFormat(BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS[i2], Locale.US);
                    ((DateFormat)cloneable).setTimeZone(Util.UTC);
                    HttpDate.BROWSER_COMPATIBLE_DATE_FORMATS[i2] = cloneable;
                }
                parsePosition.setIndex(0);
                cloneable = ((DateFormat)cloneable).parse(string, parsePosition);
                if (parsePosition.getIndex() == 0) continue;
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return cloneable;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return null;
        }
    }

    public static String format(Date date) {
        return STANDARD_DATE_FORMAT.get().format(date);
    }

    private HttpDate() {
    }
}

