/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameReader;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameWriter;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2$FrameLogger;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2$Reader;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2$Writer;
import com.zoyi.retrofit2.okhttp3.internal.framed.Variant;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ByteString;
import java.io.IOException;
import java.util.logging.Logger;

public final class Http2
implements Variant {
    private static final Logger logger = Logger.getLogger(Http2$FrameLogger.class.getName());
    private static final ByteString CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 8;
    static final byte TYPE_CONTINUATION = 9;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final byte FLAG_COMPRESSED = 32;

    @Override
    public final Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    @Override
    public final FrameReader newReader(BufferedSource bufferedSource, boolean bl) {
        return new Http2$Reader(bufferedSource, 4096, bl);
    }

    @Override
    public final FrameWriter newWriter(BufferedSink bufferedSink, boolean bl) {
        return new Http2$Writer(bufferedSink, bl);
    }

    private static IllegalArgumentException illegalArgument(String string, Object ... objectArray) {
        throw new IllegalArgumentException(Util.format(string, objectArray));
    }

    private static IOException ioException(String string, Object ... objectArray) throws IOException {
        throw new IOException(Util.format(string, objectArray));
    }

    private static int lengthWithoutPadding(int n2, byte by, short s2) throws IOException {
        if ((by & 8) != 0) {
            --n2;
        }
        if (s2 > n2) {
            throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s2, n2);
        }
        return (short)(n2 - s2);
    }

    private static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    private static void writeMedium(BufferedSink bufferedSink, int n2) throws IOException {
        bufferedSink.writeByte(n2 >>> 16 & 0xFF);
        bufferedSink.writeByte(n2 >>> 8 & 0xFF);
        bufferedSink.writeByte(n2 & 0xFF);
    }

    static /* synthetic */ ByteString access$000() {
        return CONNECTION_PREFACE;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ IOException access$200(String string, Object[] objectArray) throws IOException {
        return Http2.ioException(string, objectArray);
    }

    static /* synthetic */ int access$300(BufferedSource bufferedSource) throws IOException {
        return Http2.readMedium(bufferedSource);
    }

    static /* synthetic */ int access$400(int n2, byte by, short s2) throws IOException {
        return Http2.lengthWithoutPadding(n2, by, s2);
    }

    static /* synthetic */ IllegalArgumentException access$500(String string, Object[] objectArray) {
        return Http2.illegalArgument(string, objectArray);
    }

    static /* synthetic */ void access$600(BufferedSink bufferedSink, int n2) throws IOException {
        Http2.writeMedium(bufferedSink, n2);
    }
}

