/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameReader;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameReader$Handler;
import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.framed.HeadersMode;
import com.zoyi.retrofit2.okhttp3.internal.framed.Hpack$Reader;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2$ContinuationSource;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2$FrameLogger;
import com.zoyi.retrofit2.okhttp3.internal.framed.Settings;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

final class Http2$Reader
implements FrameReader {
    private final BufferedSource source;
    private final Http2$ContinuationSource continuation;
    private final boolean client;
    final Hpack$Reader hpackReader;

    Http2$Reader(BufferedSource bufferedSource, int n2, boolean bl) {
        this.source = bufferedSource;
        this.client = bl;
        this.continuation = new Http2$ContinuationSource(this.source);
        this.hpackReader = new Hpack$Reader(n2, this.continuation);
    }

    @Override
    public final void readConnectionPreface() throws IOException {
        if (this.client) {
            return;
        }
        ByteString byteString = this.source.readByteString(Http2.access$000().size());
        if (Http2.access$100().isLoggable(Level.FINE)) {
            Http2.access$100().fine(Util.format("<< CONNECTION %s", byteString.hex()));
        }
        if (!Http2.access$000().equals(byteString)) {
            throw Http2.access$200("Expected a connection header but was %s", new Object[]{byteString.utf8()});
        }
    }

    @Override
    public final boolean nextFrame(FrameReader$Handler frameReader$Handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (IOException iOException) {
            return false;
        }
        int n2 = Http2.access$300(this.source);
        if (n2 < 0 || n2 > 16384) {
            throw Http2.access$200("FRAME_SIZE_ERROR: %s", new Object[]{n2});
        }
        byte by = this.source.readByte();
        byte by2 = this.source.readByte();
        int n3 = this.source.readInt() & Integer.MAX_VALUE;
        if (Http2.access$100().isLoggable(Level.FINE)) {
            Http2.access$100().fine(Http2$FrameLogger.formatHeader(true, n3, n2, by, by2));
        }
        switch (by) {
            case 0: {
                this.readData(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 1: {
                this.readHeaders(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 2: {
                this.readPriority(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 3: {
                this.readRstStream(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 4: {
                this.readSettings(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 5: {
                this.readPushPromise(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 6: {
                this.readPing(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 7: {
                this.readGoAway(frameReader$Handler, n2, by2, n3);
                break;
            }
            case 8: {
                this.readWindowUpdate(frameReader$Handler, n2, by2, n3);
                break;
            }
            default: {
                this.source.skip(n2);
            }
        }
        return true;
    }

    private void readHeaders(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        short s2;
        if (n3 == 0) {
            throw Http2.access$200("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
        }
        boolean bl = (by & 1) != 0;
        short s3 = s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        if ((by & 0x20) != 0) {
            this.readPriority(frameReader$Handler, n3);
            n2 -= 5;
        }
        n2 = Http2.access$400(n2, by, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by, n3);
        frameReader$Handler.headers(false, bl, n3, -1, list, HeadersMode.HTTP_20_HEADERS);
    }

    private List<Header> readHeaderBlock(int n2, short s2, byte by, int n3) throws IOException {
        this.continuation.length = this.continuation.left = n2;
        this.continuation.padding = s2;
        this.continuation.flags = by;
        this.continuation.streamId = n3;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readData(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        boolean bl = (by & 1) != 0;
        short s2 = (by & 0x20) != 0 ? (short)1 : 0;
        if (s2 != 0) {
            throw Http2.access$200("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        n2 = Http2.access$400(n2, by, s2);
        frameReader$Handler.data(bl, n3, this.source, n2);
        this.source.skip(s2);
    }

    private void readPriority(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 5) {
            throw Http2.access$200("TYPE_PRIORITY length: %d != 5", new Object[]{n2});
        }
        if (n3 == 0) {
            throw Http2.access$200("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        this.readPriority(frameReader$Handler, n3);
    }

    private void readPriority(FrameReader$Handler frameReader$Handler, int n2) throws IOException {
        int n3 = this.source.readInt();
        boolean bl = (n3 & Integer.MIN_VALUE) != 0;
        int n4 = (this.source.readByte() & 0xFF) + 1;
        frameReader$Handler.priority(n2, n3 &= Integer.MAX_VALUE, n4, bl);
    }

    private void readRstStream(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.access$200("TYPE_RST_STREAM length: %d != 4", new Object[]{n2});
        }
        if (n3 == 0) {
            throw Http2.access$200("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        n2 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromHttp2(n2);
        if (errorCode == null) {
            throw Http2.access$200("TYPE_RST_STREAM unexpected error code: %d", new Object[]{n2});
        }
        frameReader$Handler.rstStream(n3, errorCode);
    }

    private void readSettings(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n3 != 0) {
            throw Http2.access$200("TYPE_SETTINGS streamId != 0", new Object[0]);
        }
        if ((by & 1) != 0) {
            if (n2 != 0) {
                throw Http2.access$200("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            }
            frameReader$Handler.ackSettings();
            return;
        }
        if (n2 % 6 != 0) {
            throw Http2.access$200("TYPE_SETTINGS length %% 6 != 0: %s", new Object[]{n2});
        }
        Settings settings = new Settings();
        for (n3 = 0; n3 < n2; n3 += 6) {
            int n4 = this.source.readShort();
            int n5 = this.source.readInt();
            switch (n4) {
                case 1: {
                    break;
                }
                case 2: {
                    if (n5 == 0 || n5 == 1) break;
                    throw Http2.access$200("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                }
                case 3: {
                    n4 = 4;
                    break;
                }
                case 4: {
                    n4 = 7;
                    if (n5 >= 0) break;
                    throw Http2.access$200("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                }
                case 5: {
                    if (n5 >= 16384 && n5 <= 0xFFFFFF) break;
                    throw Http2.access$200("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", new Object[]{n5});
                }
            }
            settings.set(n4, 0, n5);
        }
        frameReader$Handler.settings(false, settings);
        if (settings.getHeaderTableSize() >= 0) {
            this.hpackReader.headerTableSizeSetting(settings.getHeaderTableSize());
        }
    }

    private void readPushPromise(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n3 == 0) {
            throw Http2.access$200("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
        }
        short s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        int n4 = this.source.readInt() & Integer.MAX_VALUE;
        n2 -= 4;
        n2 = Http2.access$400(n2, by, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by, n3);
        frameReader$Handler.pushPromise(n3, n4, list);
    }

    private void readPing(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 8) {
            throw Http2.access$200("TYPE_PING length != 8: %s", new Object[]{n2});
        }
        if (n3 != 0) {
            throw Http2.access$200("TYPE_PING streamId != 0", new Object[0]);
        }
        n2 = this.source.readInt();
        n3 = this.source.readInt();
        by = (by & 1) != 0 ? (byte)1 : 0;
        frameReader$Handler.ping(by != 0, n2, n3);
    }

    private void readGoAway(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 < 8) {
            throw Http2.access$200("TYPE_GOAWAY length < 8: %s", new Object[]{n2});
        }
        if (n3 != 0) {
            throw Http2.access$200("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        by = (byte)this.source.readInt();
        n3 = this.source.readInt();
        n2 -= 8;
        ErrorCode errorCode = ErrorCode.fromHttp2(n3);
        if (errorCode == null) {
            throw Http2.access$200("TYPE_GOAWAY unexpected error code: %d", new Object[]{n3});
        }
        ByteString byteString = ByteString.EMPTY;
        if (n2 > 0) {
            byteString = this.source.readByteString(n2);
        }
        frameReader$Handler.goAway(by, errorCode, byteString);
    }

    private void readWindowUpdate(FrameReader$Handler frameReader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.access$200("TYPE_WINDOW_UPDATE length !=4: %s", new Object[]{n2});
        }
        long l2 = (long)this.source.readInt() & Integer.MAX_VALUE;
        if (l2 == 0L) {
            throw Http2.access$200("windowSizeIncrement was 0", new Object[]{l2});
        }
        frameReader$Handler.windowUpdate(n3, l2);
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }
}

