/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal;

import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.internal.JdkWithJettyBootPlatform$JettyNegoProvider;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.net.ssl.SSLSocket;

class JdkWithJettyBootPlatform
extends Platform {
    private final Method putMethod;
    private final Method getMethod;
    private final Method removeMethod;
    private final Class<?> clientProviderClass;
    private final Class<?> serverProviderClass;

    public JdkWithJettyBootPlatform(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2) {
        this.putMethod = method;
        this.getMethod = method2;
        this.removeMethod = method3;
        this.clientProviderClass = clazz;
        this.serverProviderClass = clazz2;
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) {
        object = JdkWithJettyBootPlatform.alpnProtocolNames(list);
        try {
            object = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JdkWithJettyBootPlatform$JettyNegoProvider((List<String>)object));
            this.putMethod.invoke(null, sSLSocket, object);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    @Override
    public void afterHandshake(SSLSocket sSLSocket) {
        try {
            this.removeMethod.invoke(null, sSLSocket);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError();
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket object) {
        try {
            object = (JdkWithJettyBootPlatform$JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, object));
            if (!JdkWithJettyBootPlatform$JettyNegoProvider.access$000((JdkWithJettyBootPlatform$JettyNegoProvider)object) && JdkWithJettyBootPlatform$JettyNegoProvider.access$100((JdkWithJettyBootPlatform$JettyNegoProvider)object) == null) {
                Platform.get().log(4, "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?", null);
                return null;
            }
            if (JdkWithJettyBootPlatform$JettyNegoProvider.access$000((JdkWithJettyBootPlatform$JettyNegoProvider)object)) {
                return null;
            }
            return JdkWithJettyBootPlatform$JettyNegoProvider.access$100((JdkWithJettyBootPlatform$JettyNegoProvider)object);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError();
        }
    }

    public static Platform buildIfSupported() {
        try {
            Object object = "org.eclipse.jetty.alpn.ALPN";
            GenericDeclaration genericDeclaration = Class.forName("org.eclipse.jetty.alpn.ALPN");
            GenericDeclaration genericDeclaration2 = Class.forName((String)object + "$Provider");
            Class<?> clazz = Class.forName((String)object + "$ClientProvider");
            object = Class.forName((String)object + "$ServerProvider");
            genericDeclaration2 = genericDeclaration.getMethod("put", new Class[]{SSLSocket.class, genericDeclaration2});
            Method method = genericDeclaration.getMethod("get", SSLSocket.class);
            genericDeclaration = genericDeclaration.getMethod("remove", SSLSocket.class);
            return new JdkWithJettyBootPlatform((Method)genericDeclaration2, method, (Method)genericDeclaration, clazz, (Class<?>)object);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }
}

