/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Address;
import java.net.InetSocketAddress;
import java.net.Proxy;

public final class Route {
    final Address address;
    final Proxy proxy;
    final InetSocketAddress inetSocketAddress;

    public Route(Address address, Proxy proxy, InetSocketAddress inetSocketAddress) {
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy == null");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("inetSocketAddress == null");
        }
        this.address = address;
        this.proxy = proxy;
        this.inetSocketAddress = inetSocketAddress;
    }

    public final Address address() {
        return this.address;
    }

    public final Proxy proxy() {
        return this.proxy;
    }

    public final InetSocketAddress socketAddress() {
        return this.inetSocketAddress;
    }

    public final boolean requiresTunnel() {
        return this.address.sslSocketFactory != null && this.proxy.type() == Proxy.Type.HTTP;
    }

    public final boolean equals(Object object) {
        if (object instanceof Route) {
            object = (Route)object;
            return this.address.equals(((Route)object).address) && this.proxy.equals(((Route)object).proxy) && this.inetSocketAddress.equals(((Route)object).inetSocketAddress);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = 527 + this.address.hashCode();
        n2 = n2 * 31 + this.proxy.hashCode();
        n2 = n2 * 31 + this.inetSocketAddress.hashCode();
        return n2;
    }
}

