/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.CacheControl;
import com.zoyi.retrofit2.okhttp3.Challenge;
import com.zoyi.retrofit2.okhttp3.Handshake;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response$1;
import com.zoyi.retrofit2.okhttp3.Response$Builder;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.http.OkHeaders;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class Response
implements Closeable {
    private final Request request;
    private final Protocol protocol;
    private final int code;
    private final String message;
    private final Handshake handshake;
    private final Headers headers;
    private final ResponseBody body;
    private final Response networkResponse;
    private final Response cacheResponse;
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private volatile CacheControl cacheControl;

    private Response(Response$Builder response$Builder) {
        this.request = Response$Builder.access$000(response$Builder);
        this.protocol = Response$Builder.access$100(response$Builder);
        this.code = Response$Builder.access$200(response$Builder);
        this.message = Response$Builder.access$300(response$Builder);
        this.handshake = Response$Builder.access$400(response$Builder);
        this.headers = Response$Builder.access$500(response$Builder).build();
        this.body = Response$Builder.access$600(response$Builder);
        this.networkResponse = Response$Builder.access$700(response$Builder);
        this.cacheResponse = Response$Builder.access$800(response$Builder);
        this.priorResponse = Response$Builder.access$900(response$Builder);
        this.sentRequestAtMillis = Response$Builder.access$1000(response$Builder);
        this.receivedResponseAtMillis = Response$Builder.access$1100(response$Builder);
    }

    public final Request request() {
        return this.request;
    }

    public final Protocol protocol() {
        return this.protocol;
    }

    public final int code() {
        return this.code;
    }

    public final boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public final String message() {
        return this.message;
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final List<String> headers(String string) {
        return this.headers.values(string);
    }

    public final String header(String string) {
        return this.header(string, null);
    }

    public final String header(String string, String string2) {
        if ((string = this.headers.get(string)) != null) {
            return string;
        }
        return string2;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final ResponseBody peekBody(long l2) throws IOException {
        BufferedSource bufferedSource;
        BufferedSource bufferedSource2 = this.body.source();
        bufferedSource2.request(l2);
        bufferedSource2 = bufferedSource2.buffer().clone();
        if (((Buffer)bufferedSource2).size() > l2) {
            bufferedSource = new Buffer();
            ((Buffer)bufferedSource).write((Buffer)bufferedSource2, l2);
            ((Buffer)bufferedSource2).clear();
        } else {
            bufferedSource = bufferedSource2;
        }
        return ResponseBody.create(this.body.contentType(), ((Buffer)bufferedSource).size(), bufferedSource);
    }

    public final ResponseBody body() {
        return this.body;
    }

    public final Response$Builder newBuilder() {
        return new Response$Builder(this, null);
    }

    public final boolean isRedirect() {
        switch (this.code) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public final Response networkResponse() {
        return this.networkResponse;
    }

    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    public final Response priorResponse() {
        return this.priorResponse;
    }

    public final List<Challenge> challenges() {
        String string;
        if (this.code == 401) {
            string = "WWW-Authenticate";
        } else if (this.code == 407) {
            string = "Proxy-Authenticate";
        } else {
            return Collections.emptyList();
        }
        return OkHeaders.parseChallenges(this.headers(), string);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.cacheControl = CacheControl.parse(this.headers);
        return this.cacheControl;
    }

    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @Override
    public final void close() {
        this.body.close();
    }

    public final String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    static /* synthetic */ Request access$1300(Response response) {
        return response.request;
    }

    static /* synthetic */ Protocol access$1400(Response response) {
        return response.protocol;
    }

    static /* synthetic */ int access$1500(Response response) {
        return response.code;
    }

    static /* synthetic */ String access$1600(Response response) {
        return response.message;
    }

    static /* synthetic */ Handshake access$1700(Response response) {
        return response.handshake;
    }

    static /* synthetic */ Headers access$1800(Response response) {
        return response.headers;
    }

    static /* synthetic */ ResponseBody access$1900(Response response) {
        return response.body;
    }

    static /* synthetic */ Response access$2000(Response response) {
        return response.networkResponse;
    }

    static /* synthetic */ Response access$2100(Response response) {
        return response.cacheResponse;
    }

    static /* synthetic */ Response access$2200(Response response) {
        return response.priorResponse;
    }

    static /* synthetic */ long access$2300(Response response) {
        return response.sentRequestAtMillis;
    }

    static /* synthetic */ long access$2400(Response response) {
        return response.receivedResponseAtMillis;
    }

    /* synthetic */ Response(Response$Builder response$Builder, Response$1 response$1) {
        this(response$Builder);
    }
}

