/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody$Part;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.ByteString;
import java.io.IOException;
import java.util.List;

public final class MultipartBody
extends RequestBody {
    public static final MediaType MIXED = MediaType.parse("multipart/mixed");
    public static final MediaType ALTERNATIVE = MediaType.parse("multipart/alternative");
    public static final MediaType DIGEST = MediaType.parse("multipart/digest");
    public static final MediaType PARALLEL = MediaType.parse("multipart/parallel");
    public static final MediaType FORM = MediaType.parse("multipart/form-data");
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final ByteString boundary;
    private final MediaType originalType;
    private final MediaType contentType;
    private final List<MultipartBody$Part> parts;
    private long contentLength = -1L;

    MultipartBody(ByteString byteString, MediaType mediaType, List<MultipartBody$Part> list) {
        this.boundary = byteString;
        this.originalType = mediaType;
        this.contentType = MediaType.parse(mediaType + "; boundary=" + byteString.utf8());
        this.parts = Util.immutableList(list);
    }

    public final MediaType type() {
        return this.originalType;
    }

    public final String boundary() {
        return this.boundary.utf8();
    }

    public final int size() {
        return this.parts.size();
    }

    public final List<MultipartBody$Part> parts() {
        return this.parts;
    }

    public final MultipartBody$Part part(int n2) {
        return this.parts.get(n2);
    }

    @Override
    public final MediaType contentType() {
        return this.contentType;
    }

    @Override
    public final long contentLength() throws IOException {
        long l2 = this.contentLength;
        if (l2 != -1L) {
            return l2;
        }
        this.contentLength = this.writeOrCountBytes(null, true);
        return this.contentLength;
    }

    @Override
    public final void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    private long writeOrCountBytes(BufferedSink bufferedSink, boolean bl) throws IOException {
        long l2 = 0L;
        Buffer buffer = null;
        if (bl) {
            buffer = new Buffer();
            bufferedSink = buffer;
        }
        int n2 = this.parts.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            MediaType mediaType;
            Object object = this.parts.get(i2);
            Headers headers = MultipartBody$Part.access$000((MultipartBody$Part)object);
            object = MultipartBody$Part.access$100((MultipartBody$Part)object);
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(CRLF);
            if (headers != null) {
                int n3 = headers.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    bufferedSink.writeUtf8(headers.name(i3)).write(COLONSPACE).writeUtf8(headers.value(i3)).write(CRLF);
                }
            }
            if ((mediaType = ((RequestBody)object).contentType()) != null) {
                bufferedSink.writeUtf8("Content-Type: ").writeUtf8(mediaType.toString()).write(CRLF);
            }
            if ((l3 = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink.writeUtf8("Content-Length: ").writeDecimalLong(l3).write(CRLF);
            } else if (bl) {
                buffer.clear();
                return -1L;
            }
            bufferedSink.write(CRLF);
            if (bl) {
                l2 += l3;
            } else {
                ((RequestBody)object).writeTo(bufferedSink);
            }
            bufferedSink.write(CRLF);
        }
        bufferedSink.write(DASHDASH);
        bufferedSink.write(this.boundary);
        bufferedSink.write(DASHDASH);
        bufferedSink.write(CRLF);
        if (bl) {
            l2 += buffer.size();
            buffer.clear();
        }
        return l2;
    }

    static StringBuilder appendQuotedString(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n2 = string.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuilder.append("%0A");
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append("%0D");
                    continue block5;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }
}

