/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    private final String mediaType;
    private final String type;
    private final String subtype;
    private final String charset;

    private MediaType(String string, String string2, String string3, String string4) {
        this.mediaType = string;
        this.type = string2;
        this.subtype = string3;
        this.charset = string4;
    }

    public static MediaType parse(String string) {
        Matcher matcher = TYPE_SUBTYPE.matcher(string);
        if (!matcher.lookingAt()) {
            return null;
        }
        String string2 = matcher.group(1).toLowerCase(Locale.US);
        String string3 = matcher.group(2).toLowerCase(Locale.US);
        String string4 = null;
        Matcher matcher2 = PARAMETER.matcher(string);
        int n2 = matcher.end();
        while (n2 < string.length()) {
            matcher2.region(n2, string.length());
            if (!matcher2.lookingAt()) {
                return null;
            }
            String string5 = matcher2.group(1);
            if (string5 != null && string5.equalsIgnoreCase("charset")) {
                String string6 = string5 = matcher2.group(2) != null ? matcher2.group(2) : matcher2.group(3);
                if (string4 != null && !string5.equalsIgnoreCase(string4)) {
                    throw new IllegalArgumentException("Multiple different charsets: " + string);
                }
                string4 = string5;
            }
            n2 = matcher2.end();
        }
        return new MediaType(string, string2, string3, string4);
    }

    public final String type() {
        return this.type;
    }

    public final String subtype() {
        return this.subtype;
    }

    public final Charset charset() {
        if (this.charset != null) {
            return Charset.forName(this.charset);
        }
        return null;
    }

    public final Charset charset(Charset charset) {
        if (this.charset != null) {
            return Charset.forName(this.charset);
        }
        return charset;
    }

    public final String toString() {
        return this.mediaType;
    }

    public final boolean equals(Object object) {
        return object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
    }

    public final int hashCode() {
        return this.mediaType.hashCode();
    }
}

