/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.CipherSuite;
import com.zoyi.retrofit2.okhttp3.ConnectionSpec$1;
import com.zoyi.retrofit2.okhttp3.ConnectionSpec$Builder;
import com.zoyi.retrofit2.okhttp3.TlsVersion;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
    public static final ConnectionSpec MODERN_TLS = new ConnectionSpec$Builder(true).cipherSuites(APPROVED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec COMPATIBLE_TLS = new ConnectionSpec$Builder(MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec CLEARTEXT = new ConnectionSpec$Builder(false).build();
    private final boolean tls;
    private final boolean supportsTlsExtensions;
    private final String[] cipherSuites;
    private final String[] tlsVersions;

    private ConnectionSpec(ConnectionSpec$Builder connectionSpec$Builder) {
        this.tls = ConnectionSpec$Builder.access$000(connectionSpec$Builder);
        this.cipherSuites = ConnectionSpec$Builder.access$100(connectionSpec$Builder);
        this.tlsVersions = ConnectionSpec$Builder.access$200(connectionSpec$Builder);
        this.supportsTlsExtensions = ConnectionSpec$Builder.access$300(connectionSpec$Builder);
    }

    public final boolean isTls() {
        return this.tls;
    }

    public final List<CipherSuite> cipherSuites() {
        if (this.cipherSuites == null) {
            return null;
        }
        CipherSuite[] cipherSuiteArray = new CipherSuite[this.cipherSuites.length];
        for (int i2 = 0; i2 < this.cipherSuites.length; ++i2) {
            cipherSuiteArray[i2] = CipherSuite.forJavaName(this.cipherSuites[i2]);
        }
        return Util.immutableList(cipherSuiteArray);
    }

    public final List<TlsVersion> tlsVersions() {
        if (this.tlsVersions == null) {
            return null;
        }
        TlsVersion[] tlsVersionArray = new TlsVersion[this.tlsVersions.length];
        for (int i2 = 0; i2 < this.tlsVersions.length; ++i2) {
            tlsVersionArray[i2] = TlsVersion.forJavaName(this.tlsVersions[i2]);
        }
        return Util.immutableList(tlsVersionArray);
    }

    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    final void apply(SSLSocket sSLSocket, boolean bl) {
        ConnectionSpec connectionSpec = this.supportedSpec(sSLSocket, bl);
        if (connectionSpec.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersions);
        }
        if (connectionSpec.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuites);
        }
    }

    private ConnectionSpec supportedSpec(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray;
        String[] stringArray2 = this.cipherSuites != null ? Util.intersect(String.class, this.cipherSuites, sSLSocket.getEnabledCipherSuites()) : sSLSocket.getEnabledCipherSuites();
        String[] stringArray3 = stringArray = this.tlsVersions != null ? Util.intersect(String.class, this.tlsVersions, sSLSocket.getEnabledProtocols()) : sSLSocket.getEnabledProtocols();
        if (bl && Util.contains(sSLSocket.getSupportedCipherSuites(), "TLS_FALLBACK_SCSV")) {
            stringArray2 = Util.concat(stringArray2, "TLS_FALLBACK_SCSV");
        }
        return new ConnectionSpec$Builder(this).cipherSuites(stringArray2).tlsVersions(stringArray).build();
    }

    public final boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.tls) {
            return false;
        }
        if (this.tlsVersions != null && !ConnectionSpec.nonEmptyIntersection(this.tlsVersions, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || ConnectionSpec.nonEmptyIntersection(this.cipherSuites, sSLSocket.getEnabledCipherSuites());
    }

    private static boolean nonEmptyIntersection(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            if (!Util.contains(stringArray2, string)) continue;
            return true;
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        if (this.tls != ((ConnectionSpec)object).tls) {
            return false;
        }
        if (this.tls) {
            if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n2 = 17;
        if (this.tls) {
            n2 = 527 + Arrays.hashCode(this.cipherSuites);
            n2 = n2 * 31 + Arrays.hashCode(this.tlsVersions);
            n2 = n2 * 31 + (this.supportsTlsExtensions ? 0 : 1);
        }
        return n2;
    }

    public final String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string2 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string + ", tlsVersions=" + string2 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }

    static /* synthetic */ boolean access$400(ConnectionSpec connectionSpec) {
        return connectionSpec.tls;
    }

    static /* synthetic */ String[] access$500(ConnectionSpec connectionSpec) {
        return connectionSpec.cipherSuites;
    }

    static /* synthetic */ String[] access$600(ConnectionSpec connectionSpec) {
        return connectionSpec.tlsVersions;
    }

    static /* synthetic */ boolean access$700(ConnectionSpec connectionSpec) {
        return connectionSpec.supportsTlsExtensions;
    }

    /* synthetic */ ConnectionSpec(ConnectionSpec$Builder connectionSpec$Builder, ConnectionSpec$1 connectionSpec$1) {
        this(connectionSpec$Builder);
    }
}

