/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Address;
import com.zoyi.retrofit2.okhttp3.ConnectionPool$1;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import com.zoyi.retrofit2.okhttp3.internal.RouteDatabase;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.http.StreamAllocation;
import com.zoyi.retrofit2.okhttp3.internal.io.RealConnection;
import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final Executor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final Runnable cleanupRunnable = new ConnectionPool$1(this);
    private final Deque<RealConnection> connections = new ArrayDeque<RealConnection>();
    final RouteDatabase routeDatabase = new RouteDatabase();
    boolean cleanupRunning;

    public ConnectionPool() {
        this(5, 5L, TimeUnit.MINUTES);
    }

    public ConnectionPool(int n2, long l2, TimeUnit timeUnit) {
        this.maxIdleConnections = n2;
        this.keepAliveDurationNs = timeUnit.toNanos(l2);
        if (l2 <= 0L) {
            throw new IllegalArgumentException("keepAliveDuration <= 0: " + l2);
        }
    }

    public final synchronized int idleConnectionCount() {
        int n2 = 0;
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.allocations.isEmpty()) continue;
            ++n2;
        }
        return n2;
    }

    public final synchronized int connectionCount() {
        return this.connections.size();
    }

    final RealConnection get(Address address, StreamAllocation streamAllocation) {
        assert (Thread.holdsLock(this));
        for (RealConnection realConnection : this.connections) {
            if (realConnection.allocations.size() >= realConnection.allocationLimit || !address.equals(realConnection.route().address) || realConnection.noNewStreams) continue;
            streamAllocation.acquire(realConnection);
            return realConnection;
        }
        return null;
    }

    final void put(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    final boolean connectionBecameIdle(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (realConnection.noNewStreams || this.maxIdleConnections == 0) {
            this.connections.remove(realConnection);
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        ArrayList<RealConnection> arrayList = new ArrayList<RealConnection>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Iterator<RealConnection> object = this.connections.iterator();
            while (object.hasNext()) {
                RealConnection realConnection = object.next();
                if (!realConnection.allocations.isEmpty()) continue;
                realConnection.noNewStreams = true;
                arrayList.add(realConnection);
                object.remove();
            }
        }
        for (RealConnection realConnection : arrayList) {
            Util.closeQuietly(realConnection.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long cleanup(long l2) {
        int n2 = 0;
        int n3 = 0;
        RealConnection realConnection = null;
        long l3 = Long.MIN_VALUE;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (RealConnection realConnection2 : this.connections) {
                if (this.pruneAndGetAllocationCount(realConnection2, l2) > 0) {
                    ++n2;
                    continue;
                }
                ++n3;
                long l4 = l2 - realConnection2.idleAtNanos;
                if (l4 <= l3) continue;
                l3 = l4;
                realConnection = realConnection2;
            }
            if (l3 < this.keepAliveDurationNs && n3 <= this.maxIdleConnections) {
                if (n3 > 0) {
                    return this.keepAliveDurationNs - l3;
                }
                if (n2 > 0) {
                    return this.keepAliveDurationNs;
                }
                this.cleanupRunning = false;
                return -1L;
            }
            this.connections.remove(realConnection);
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l2) {
        List<Reference<StreamAllocation>> list = realConnection.allocations;
        int n2 = 0;
        while (n2 < list.size()) {
            Reference<StreamAllocation> reference = list.get(n2);
            if (reference.get() != null) {
                ++n2;
                continue;
            }
            Platform.get().log(5, "A connection to " + realConnection.route().address().url() + " was leaked. Did you forget to close a response body?", null);
            list.remove(n2);
            realConnection.noNewStreams = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l2 - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }
}

