/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.adapter.rxjava;

import com.zoyi.retrofit2.Response;

public final class Result<T> {
    private final Response<T> response;
    private final Throwable error;

    public static <T> Result<T> error(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("error == null");
        }
        return new Result<T>(null, throwable);
    }

    public static <T> Result<T> response(Response<T> response) {
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        return new Result<T>(response, null);
    }

    private Result(Response<T> response, Throwable throwable) {
        this.response = response;
        this.error = throwable;
    }

    public final Response<T> response() {
        return this.response;
    }

    public final Throwable error() {
        return this.error;
    }

    public final boolean isError() {
        return this.error != null;
    }
}

