/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.Utils$GenericArrayTypeImpl;
import com.zoyi.retrofit2.Utils$ParameterizedTypeImpl;
import com.zoyi.retrofit2.Utils$WildcardTypeImpl;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import com.zoyi.retrofit2.okio.Buffer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.NoSuchElementException;

final class Utils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private Utils() {
    }

    static Class<?> getRawType(Type type) {
        while (true) {
            if (type == null) {
                throw new NullPointerException("type == null");
            }
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                type = (ParameterizedType)type;
                if (!((type = type.getRawType()) instanceof Class)) {
                    throw new IllegalArgumentException();
                }
                return (Class)type;
            }
            if (type instanceof GenericArrayType) {
                type = ((GenericArrayType)type).getGenericComponentType();
                return Array.newInstance(Utils.getRawType(type), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (!(type instanceof WildcardType)) break;
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + type.getClass().getName());
    }

    static boolean equals(Type type, Type type2) {
        while (true) {
            if (type == type2) {
                return true;
            }
            if (type instanceof Class) {
                return type.equals(type2);
            }
            if (type instanceof ParameterizedType) {
                if (!(type2 instanceof ParameterizedType)) {
                    return false;
                }
                type = (ParameterizedType)type;
                type2 = (ParameterizedType)type2;
                return Utils.equal(type.getOwnerType(), type2.getOwnerType()) && type.getRawType().equals(type2.getRawType()) && Arrays.equals(type.getActualTypeArguments(), type2.getActualTypeArguments());
            }
            if (!(type instanceof GenericArrayType)) break;
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            type2 = type2.getGenericComponentType();
            type = type.getGenericComponentType();
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            return Arrays.equals(type.getUpperBounds(), type2.getUpperBounds()) && Arrays.equals(type.getLowerBounds(), type2.getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            type = (TypeVariable)type;
            type2 = (TypeVariable)type2;
            return type.getGenericDeclaration() == type2.getGenericDeclaration() && type.getName().equals(type2.getName());
        }
        return false;
    }

    static Type getGenericSupertype(Type object, Class<?> object2, Class<?> clazz) {
        block0: while (true) {
            if (clazz == object2) {
                return object;
            }
            if (clazz.isInterface()) {
                object = ((Class)object2).getInterfaces();
                int n2 = ((Class<?>[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (object[i2] == clazz) {
                        return ((Class)object2).getGenericInterfaces()[i2];
                    }
                    if (!clazz.isAssignableFrom(object[i2])) continue;
                    Type type = ((Class)object2).getGenericInterfaces()[i2];
                    object2 = object[i2];
                    object = type;
                    continue block0;
                }
            }
            if (((Class)object2).isInterface()) break;
            while (object2 != Object.class) {
                object = ((Class)object2).getSuperclass();
                if (object == clazz) {
                    return ((Class)object2).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object)) {
                    Type type = ((Class)object2).getGenericSuperclass();
                    object2 = object;
                    object = type;
                    continue block0;
                }
                object2 = object;
            }
            break;
        }
        return clazz;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!object.equals(objectArray[i2])) continue;
            return i2;
        }
        throw new NoSuchElementException();
    }

    private static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static int hashCodeOrZero(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }

    static String typeToString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        return Utils.resolve(type, clazz, Utils.getGenericSupertype(type, clazz, clazz2));
    }

    static Type resolve(Type type, Class<?> clazz, Type typeArray) {
        Type type2;
        while (typeArray instanceof TypeVariable) {
            type2 = (TypeVariable)typeArray;
            if ((typeArray = Utils.resolveTypeVariable(type, clazz, type2)) != type2) continue;
            return typeArray;
        }
        if (typeArray instanceof Class && ((Class)typeArray).isArray()) {
            Type type3;
            type2 = (Class)typeArray;
            if ((typeArray = ((Class)type2).getComponentType()) == (type3 = Utils.resolve(type, clazz, typeArray))) {
                return type2;
            }
            return new Utils$GenericArrayTypeImpl(type3);
        }
        if (typeArray instanceof GenericArrayType) {
            Type type4;
            type2 = (GenericArrayType)typeArray;
            if ((typeArray = type2.getGenericComponentType()) == (type4 = Utils.resolve(type, clazz, typeArray))) {
                return type2;
            }
            return new Utils$GenericArrayTypeImpl(type4);
        }
        if (typeArray instanceof ParameterizedType) {
            type2 = (ParameterizedType)typeArray;
            Type type5 = Utils.resolve(type, clazz, typeArray = type2.getOwnerType());
            boolean bl = type5 != typeArray;
            typeArray = type2.getActualTypeArguments();
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type6 = Utils.resolve(type, clazz, typeArray[i2]);
                if (type6 == typeArray[i2]) continue;
                if (!bl) {
                    typeArray = (Type[])typeArray.clone();
                    bl = true;
                }
                typeArray[i2] = type6;
            }
            if (bl) {
                return new Utils$ParameterizedTypeImpl(type5, type2.getRawType(), typeArray);
            }
            return type2;
        }
        if (typeArray instanceof WildcardType) {
            Type type7;
            type2 = (WildcardType)typeArray;
            typeArray = type2.getLowerBounds();
            Type[] typeArray2 = type2.getUpperBounds();
            if (typeArray.length == 1) {
                Type type8 = Utils.resolve(type, clazz, typeArray[0]);
                if (type8 != typeArray[0]) {
                    return new Utils$WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type8});
                }
            } else if (typeArray2.length == 1 && (type7 = Utils.resolve(type, clazz, typeArray2[0])) != typeArray2[0]) {
                return new Utils$WildcardTypeImpl(new Type[]{type7}, EMPTY_TYPE_ARRAY);
            }
            return type2;
        }
        return typeArray;
    }

    private static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = Utils.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        if ((type = Utils.getGenericSupertype(type, clazz, clazz2)) instanceof ParameterizedType) {
            int n2 = Utils.indexOf(clazz2.getTypeParameters(), typeVariable);
            return ((ParameterizedType)type).getActualTypeArguments()[n2];
        }
        return typeVariable;
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        if ((typeVariable = typeVariable.getGenericDeclaration()) instanceof Class) {
            return (Class)((Object)typeVariable);
        }
        return null;
    }

    static void checkNotPrimitive(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            throw new IllegalArgumentException();
        }
    }

    static <T> T checkNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException(string);
        }
        return t2;
    }

    static boolean isAnnotationPresent(Annotation[] annotationArray, Class<? extends Annotation> clazz) {
        for (Annotation annotation : annotationArray) {
            if (!clazz.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    static ResponseBody buffer(ResponseBody responseBody) throws IOException {
        Buffer buffer = new Buffer();
        responseBody.source().readAll(buffer);
        return ResponseBody.create(responseBody.contentType(), responseBody.contentLength(), buffer);
    }

    static <T> void validateServiceInterface(Class<T> clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("API declarations must be interfaces.");
        }
        if (clazz.getInterfaces().length > 0) {
            throw new IllegalArgumentException("API interfaces must not extend other interfaces.");
        }
    }

    static Type getParameterUpperBound(int n2, ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (n2 < 0 || n2 >= typeArray.length) {
            throw new IllegalArgumentException("Index " + n2 + " not in range [0," + typeArray.length + ") for " + parameterizedType);
        }
        Type type = typeArray[n2];
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        return type;
    }

    static boolean hasUnresolvableType(Type object) {
        while (true) {
            if (object instanceof Class) {
                return false;
            }
            if (object instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)object;
                for (Type type : parameterizedType.getActualTypeArguments()) {
                    if (!Utils.hasUnresolvableType(type)) continue;
                    return true;
                }
                return false;
            }
            if (!(object instanceof GenericArrayType)) break;
            object = ((GenericArrayType)object).getGenericComponentType();
        }
        if (object instanceof TypeVariable) {
            return true;
        }
        if (object instanceof WildcardType) {
            return true;
        }
        String string = object == null ? "null" : object.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + object + "> is of type " + string);
    }

    static Type getCallResponseType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Call return type must be parameterized as Call<Foo> or Call<? extends Foo>");
        }
        return Utils.getParameterUpperBound(0, (ParameterizedType)type);
    }
}

