/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.Converter;
import com.zoyi.retrofit2.ParameterHandler;
import com.zoyi.retrofit2.RequestBuilder;
import com.zoyi.retrofit2.ServiceMethod$Builder;
import com.zoyi.retrofit2.okhttp3.Call$Factory;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ServiceMethod<T> {
    static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
    static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    final Call$Factory callFactory;
    final CallAdapter<?> callAdapter;
    private final HttpUrl baseUrl;
    private final Converter<ResponseBody, T> responseConverter;
    private final String httpMethod;
    private final String relativeUrl;
    private final Headers headers;
    private final MediaType contentType;
    private final boolean hasBody;
    private final boolean isFormEncoded;
    private final boolean isMultipart;
    private final ParameterHandler<?>[] parameterHandlers;

    ServiceMethod(ServiceMethod$Builder<T> serviceMethod$Builder) {
        this.callFactory = serviceMethod$Builder.retrofit.callFactory();
        this.callAdapter = serviceMethod$Builder.callAdapter;
        this.baseUrl = serviceMethod$Builder.retrofit.baseUrl();
        this.responseConverter = serviceMethod$Builder.responseConverter;
        this.httpMethod = serviceMethod$Builder.httpMethod;
        this.relativeUrl = serviceMethod$Builder.relativeUrl;
        this.headers = serviceMethod$Builder.headers;
        this.contentType = serviceMethod$Builder.contentType;
        this.hasBody = serviceMethod$Builder.hasBody;
        this.isFormEncoded = serviceMethod$Builder.isFormEncoded;
        this.isMultipart = serviceMethod$Builder.isMultipart;
        this.parameterHandlers = serviceMethod$Builder.parameterHandlers;
    }

    final Request toRequest(Object ... objectArray) throws IOException {
        ParameterHandler<?>[] parameterHandlerArray;
        RequestBuilder requestBuilder = new RequestBuilder(this.httpMethod, this.baseUrl, this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart);
        int n2 = objectArray != null ? objectArray.length : 0;
        if (n2 != (parameterHandlerArray = this.parameterHandlers).length) {
            throw new IllegalArgumentException("Argument count (" + n2 + ") doesn't match expected count (" + parameterHandlerArray.length + ")");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            parameterHandlerArray[i2].apply(requestBuilder, objectArray[i2]);
        }
        return requestBuilder.build();
    }

    final T toResponse(ResponseBody responseBody) throws IOException {
        return this.responseConverter.convert(responseBody);
    }

    static Set<String> parsePathParameters(String object) {
        object = PARAM_URL_REGEX.matcher((CharSequence)object);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        while (((Matcher)object).find()) {
            linkedHashSet.add(((Matcher)object).group(1));
        }
        return linkedHashSet;
    }

    static Class<?> boxIfPrimitive(Class<?> clazz) {
        if (Boolean.TYPE == clazz) {
            return Boolean.class;
        }
        if (Byte.TYPE == clazz) {
            return Byte.class;
        }
        if (Character.TYPE == clazz) {
            return Character.class;
        }
        if (Double.TYPE == clazz) {
            return Double.class;
        }
        if (Float.TYPE == clazz) {
            return Float.class;
        }
        if (Integer.TYPE == clazz) {
            return Integer.class;
        }
        if (Long.TYPE == clazz) {
            return Long.class;
        }
        if (Short.TYPE == clazz) {
            return Short.class;
        }
        return clazz;
    }
}

