/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import android.os.Build;
import com.zoyi.retrofit2.CallAdapter$Factory;
import com.zoyi.retrofit2.DefaultCallAdapterFactory;
import com.zoyi.retrofit2.ExecutorCallAdapterFactory;
import com.zoyi.retrofit2.Platform$Android;
import com.zoyi.retrofit2.Platform$IOS;
import com.zoyi.retrofit2.Platform$Java8;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;

class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Platform$Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            Class.forName("java.util.Optional");
            return new Platform$Java8();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("org.robovm.apple.foundation.NSObject");
                return new Platform$IOS();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new Platform();
            }
        }
    }

    Executor defaultCallbackExecutor() {
        return null;
    }

    CallAdapter$Factory defaultCallAdapterFactory(Executor executor) {
        if (executor != null) {
            return new ExecutorCallAdapterFactory(executor);
        }
        return DefaultCallAdapterFactory.INSTANCE;
    }

    boolean isDefaultMethod(Method method) {
        return false;
    }

    Object invokeDefaultMethod(Method method, Class<?> clazz, Object object, Object ... objectArray) throws Throwable {
        throw new UnsupportedOperationException();
    }
}

