/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.ws;

import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketProtocol;
import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketWriter$FrameSink;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.Sink;
import java.io.IOException;
import java.util.Random;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final WebSocketWriter$FrameSink frameSink = new WebSocketWriter$FrameSink(this);
    boolean activeWriter;
    final byte[] maskKey;
    final byte[] maskBuffer;

    WebSocketWriter(boolean bl, BufferedSink bufferedSink, Random random) {
        if (bufferedSink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = bl;
        this.sink = bufferedSink;
        this.random = random;
        this.maskKey = bl ? new byte[4] : null;
        this.maskBuffer = bl ? new byte[8192] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writePing(ByteString byteString) throws IOException {
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(9, byteString);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writePong(ByteString byteString) throws IOException {
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(10, byteString);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeClose(int n2, ByteString byteString) throws IOException {
        Object object;
        ByteString byteString2 = ByteString.EMPTY;
        if (n2 != 0 || byteString != null) {
            if (n2 != 0) {
                WebSocketProtocol.validateCloseCode(n2);
            }
            object = new Buffer();
            ((Buffer)object).writeShort(n2);
            if (byteString != null) {
                ((Buffer)object).write(byteString);
            }
            byteString2 = ((Buffer)object).readByteString();
        }
        object = this;
        synchronized (object) {
            try {
                this.writeControlFrameSynchronized(8, byteString2);
            }
            finally {
                this.writerClosed = true;
            }
            return;
        }
    }

    private void writeControlFrameSynchronized(int n2, ByteString byteString) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n3 = byteString.size();
        if ((long)n3 > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        n2 = 0x80 | n2;
        this.sink.writeByte(n2);
        if (this.isClient) {
            n2 = n3 | 0x80;
            this.sink.writeByte(n2);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            byte[] byArray = byteString.toByteArray();
            WebSocketProtocol.toggleMask(byArray, byArray.length, this.maskKey, 0L);
            this.sink.write(byArray);
        } else {
            this.sink.writeByte(n3);
            this.sink.write(byteString);
        }
        this.sink.flush();
    }

    final Sink newMessageSink(int n2, long l2) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = n2;
        this.frameSink.contentLength = l2;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    final void writeMessageFrameSynchronized(int n2, long l2, boolean bl, boolean bl2) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n3 = n2 = bl ? n2 : 0;
        if (bl2) {
            n2 |= 0x80;
        }
        this.sink.writeByte(n2);
        n2 = 0;
        if (this.isClient) {
            n2 = 128;
        }
        if (l2 <= 125L) {
            this.sink.writeByte(n2 |= (int)l2);
        } else if (l2 <= 65535L) {
            this.sink.writeByte(n2 |= 0x7E);
            this.sink.writeShort((int)l2);
        } else {
            this.sink.writeByte(n2 |= 0x7F);
            this.sink.writeLong(l2);
        }
        if (this.isClient) {
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                n2 = (int)Math.min(l2, (long)this.maskBuffer.length);
                if ((n2 = this.buffer.read(this.maskBuffer, 0, n2)) == -1) {
                    throw new AssertionError();
                }
                WebSocketProtocol.toggleMask(this.maskBuffer, n2, this.maskKey, i2);
                this.sink.write(this.maskBuffer, 0, n2);
            }
        } else {
            this.sink.write(this.buffer, l2);
        }
        this.sink.emit();
    }
}

