/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.ws;

import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketProtocol;
import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketReader$FrameCallback;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSource;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final WebSocketReader$FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    long frameBytesRead;
    boolean isFinalFrame;
    boolean isControlFrame;
    boolean isMasked;
    final byte[] maskKey = new byte[4];
    final byte[] maskBuffer = new byte[8192];

    WebSocketReader(boolean bl, BufferedSource bufferedSource, WebSocketReader$FrameCallback webSocketReader$FrameCallback) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        if (webSocketReader$FrameCallback == null) {
            throw new NullPointerException("frameCallback == null");
        }
        this.isClient = bl;
        this.source = bufferedSource;
        this.frameCallback = webSocketReader$FrameCallback;
    }

    final void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
            return;
        }
        this.readMessageFrame();
    }

    private void readHeader() throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException("closed");
        }
        long l2 = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            n2 = this.source.readByte() & 0xFF;
        }
        finally {
            this.source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
        }
        this.opcode = n2 & 0xF;
        this.isFinalFrame = (n2 & 0x80) != 0;
        boolean bl = this.isControlFrame = (n2 & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean bl2 = (n2 & 0x40) != 0;
        boolean bl3 = (n2 & 0x20) != 0;
        int n3 = n2 = (n2 & 0x10) != 0 ? 1 : 0;
        if (bl2 || bl3 || n2 != 0) {
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        n2 = this.source.readByte() & 0xFF;
        boolean bl4 = this.isMasked = (n2 & 0x80) != 0;
        if (this.isMasked == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = n2 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = (long)this.source.readShort() & 0xFFFFL;
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Long.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        this.frameBytesRead = 0L;
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (this.isMasked) {
            this.source.readFully(this.maskKey);
        }
    }

    private void readControlFrame() throws IOException {
        int n2;
        Object object = new Buffer();
        if (this.frameBytesRead < this.frameLength) {
            if (this.isClient) {
                this.source.readFully((Buffer)object, this.frameLength);
            } else {
                while (this.frameBytesRead < this.frameLength) {
                    n2 = (int)Math.min(this.frameLength - this.frameBytesRead, (long)this.maskBuffer.length);
                    int n3 = this.source.read(this.maskBuffer, 0, n2);
                    if (n3 == -1) {
                        throw new EOFException();
                    }
                    WebSocketProtocol.toggleMask(this.maskBuffer, n3, this.maskKey, this.frameBytesRead);
                    ((Buffer)object).write(this.maskBuffer, 0, n3);
                    this.frameBytesRead += (long)n3;
                }
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(((Buffer)object).readByteString());
                return;
            }
            case 10: {
                this.frameCallback.onReadPong(((Buffer)object).readByteString());
                return;
            }
            case 8: {
                n2 = 1005;
                String string = "";
                long l2 = ((Buffer)object).size();
                if (l2 == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (l2 != 0L) {
                    n2 = ((Buffer)object).readShort();
                    string = ((Buffer)object).readUtf8();
                    object = WebSocketProtocol.closeCodeExceptionMessage(n2);
                    if (object != null) {
                        throw new ProtocolException((String)object);
                    }
                }
                this.frameCallback.onReadClose(n2, string);
                this.closed = true;
                return;
            }
        }
        throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.opcode));
    }

    private void readMessageFrame() throws IOException {
        int n2 = this.opcode;
        if (n2 != 1 && n2 != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(n2));
        }
        Buffer buffer = new Buffer();
        this.readMessage(buffer);
        if (n2 == 1) {
            this.frameCallback.onReadMessage(buffer.readUtf8());
            return;
        }
        this.frameCallback.onReadMessage(buffer.readByteString());
    }

    final void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage(Buffer buffer) throws IOException {
        while (true) {
            long l2;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (this.frameBytesRead == this.frameLength) {
                if (this.isFinalFrame) {
                    return;
                }
                this.readUntilNonControlFrame();
                if (this.opcode != 0) {
                    throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.opcode));
                }
                if (this.isFinalFrame && this.frameLength == 0L) {
                    return;
                }
            }
            long l3 = this.frameLength - this.frameBytesRead;
            if (this.isMasked) {
                l2 = this.source.read(this.maskBuffer, 0, (int)(l3 = Math.min(l3, (long)this.maskBuffer.length)));
                if (l2 == -1L) {
                    throw new EOFException();
                }
                WebSocketProtocol.toggleMask(this.maskBuffer, l2, this.maskKey, this.frameBytesRead);
                buffer.write(this.maskBuffer, 0, (int)l2);
            } else {
                l2 = this.source.read(buffer, l3);
                if (l2 == -1L) {
                    throw new EOFException();
                }
            }
            this.frameBytesRead += l2;
        }
    }
}

