/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.ws;

import com.zoyi.io.socket.okhttp3.Call;
import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.WebSocket;
import com.zoyi.io.socket.okhttp3.WebSocketListener;
import com.zoyi.io.socket.okhttp3.internal.Internal;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$1;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$2;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$CancelRunnable;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$Close;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$Message;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$PingRunnable;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket$Streams;
import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketProtocol;
import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketReader;
import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketReader$FrameCallback;
import com.zoyi.io.socket.okhttp3.internal.ws.WebSocketWriter;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.Okio;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class RealWebSocket
implements WebSocket,
WebSocketReader$FrameCallback {
    private static final List<Protocol> ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    private final Request originalRequest;
    final WebSocketListener listener;
    private final Random random;
    private final String key;
    private Call call;
    private final Runnable writerRunnable;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private ScheduledExecutorService executor;
    private RealWebSocket$Streams streams;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private final ArrayDeque<Object> messageAndCloseQueue = new ArrayDeque();
    private long queueSize;
    private boolean enqueuedClose;
    private ScheduledFuture<?> cancelFuture;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private boolean failed;
    int pingCount;
    int pongCount;

    public RealWebSocket(Request object, WebSocketListener webSocketListener, Random random) {
        if (!"GET".equals(((Request)object).method())) {
            throw new IllegalArgumentException("Request must be GET: " + ((Request)object).method());
        }
        this.originalRequest = object;
        this.listener = webSocketListener;
        this.random = random;
        object = new byte[16];
        random.nextBytes((byte[])object);
        this.key = ByteString.of((byte[])object).base64();
        this.writerRunnable = new RealWebSocket$1(this);
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    @Override
    public final synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public final void cancel() {
        this.call.cancel();
    }

    public final void connect(OkHttpClient okHttpClient) {
        okHttpClient = okHttpClient.newBuilder().protocols(ONLY_HTTP1).build();
        int n2 = okHttpClient.pingIntervalMillis();
        Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        this.call = Internal.instance.newWebSocketCall(okHttpClient, request);
        this.call.enqueue(new RealWebSocket$2(this, request, n2));
    }

    final void checkResponse(Response object) throws ProtocolException {
        if (((Response)object).code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + ((Response)object).code() + " " + ((Response)object).message() + "'");
        }
        String string = ((Response)object).header("Connection");
        if (!"Upgrade".equalsIgnoreCase(string)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + string + "'");
        }
        string = ((Response)object).header("Upgrade");
        if (!"websocket".equalsIgnoreCase(string)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + string + "'");
        }
        object = ((Response)object).header("Sec-WebSocket-Accept");
        string = ByteString.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!string.equals(object)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + string + "' but was '" + (String)object + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initReaderAndWriter(String string, long l2, RealWebSocket$Streams realWebSocket$Streams) throws IOException {
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.streams = realWebSocket$Streams;
            this.writer = new WebSocketWriter(realWebSocket$Streams.client, realWebSocket$Streams.sink, this.random);
            this.executor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(string, false));
            if (l2 != 0L) {
                this.executor.scheduleAtFixedRate(new RealWebSocket$PingRunnable(this, null), l2, l2, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(realWebSocket$Streams.client, realWebSocket$Streams.source, this);
    }

    public final void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    final boolean processNextFrame() throws IOException {
        try {
            this.reader.processNextFrame();
            return this.receivedCloseCode == -1;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    final synchronized int pingCount() {
        return this.pingCount;
    }

    final synchronized int pongCount() {
        return this.pongCount;
    }

    @Override
    public final void onReadMessage(String string) throws IOException {
        this.listener.onMessage((WebSocket)this, string);
    }

    @Override
    public final void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public final synchronized void onReadPing(ByteString byteString) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add(byteString);
        this.runWriter();
        ++this.pingCount;
    }

    @Override
    public final synchronized void onReadPong(ByteString byteString) {
        ++this.pongCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onReadClose(int n2, String string) {
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        RealWebSocket$Streams realWebSocket$Streams = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.receivedCloseCode != -1) {
                throw new IllegalStateException("already closed");
            }
            this.receivedCloseCode = n2;
            this.receivedCloseReason = string;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                realWebSocket$Streams = this.streams;
                this.streams = null;
                if (this.cancelFuture != null) {
                    this.cancelFuture.cancel(false);
                }
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onClosing(this, n2, string);
            if (realWebSocket$Streams != null) {
                this.listener.onClosed(this, n2, string);
            }
            return;
        }
        finally {
            Util.closeQuietly(realWebSocket$Streams);
        }
    }

    @Override
    public final boolean send(String string) {
        if (string == null) {
            throw new NullPointerException("text == null");
        }
        return this.send(ByteString.encodeUtf8(string), 1);
    }

    @Override
    public final boolean send(ByteString byteString) {
        if (byteString == null) {
            throw new NullPointerException("bytes == null");
        }
        return this.send(byteString, 2);
    }

    private synchronized boolean send(ByteString byteString, int n2) {
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)byteString.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)byteString.size();
        this.messageAndCloseQueue.add(new RealWebSocket$Message(n2, byteString));
        this.runWriter();
        return true;
    }

    final synchronized boolean pong(ByteString byteString) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add(byteString);
        this.runWriter();
        return true;
    }

    @Override
    public final boolean close(int n2, String string) {
        return this.close(n2, string, 60000L);
    }

    final synchronized boolean close(int n2, String string, long l2) {
        WebSocketProtocol.validateCloseCode(n2);
        ByteString byteString = null;
        if (string != null && (long)(byteString = ByteString.encodeUtf8(string)).size() > 123L) {
            throw new IllegalArgumentException("reason.size() > 123: " + string);
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new RealWebSocket$Close(n2, byteString, l2));
        this.runWriter();
        return true;
    }

    private void runWriter() {
        assert (Thread.holdsLock(this));
        if (this.executor != null) {
            this.executor.execute(this.writerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean writeOneFrame() throws IOException {
        ByteString byteString;
        Object object;
        Object object2 = null;
        int n2 = 0;
        String string = null;
        RealWebSocket$Streams realWebSocket$Streams = null;
        Object object3 = this;
        synchronized (object3) {
            if (this.failed) {
                return false;
            }
            object = this.writer;
            byteString = this.pongQueue.poll();
            if (byteString == null) {
                object2 = this.messageAndCloseQueue.poll();
                if (object2 instanceof RealWebSocket$Close) {
                    n2 = this.receivedCloseCode;
                    string = this.receivedCloseReason;
                    if (n2 != -1) {
                        realWebSocket$Streams = this.streams;
                        this.streams = null;
                        this.executor.shutdown();
                    } else {
                        this.cancelFuture = this.executor.schedule(new RealWebSocket$CancelRunnable(this), ((RealWebSocket$Close)object2).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
                    }
                } else if (object2 == null) {
                    return false;
                }
            }
        }
        try {
            if (byteString != null) {
                ((WebSocketWriter)object).writePong(byteString);
            } else if (object2 instanceof RealWebSocket$Message) {
                object3 = ((RealWebSocket$Message)object2).data;
                object = Okio.buffer(((WebSocketWriter)object).newMessageSink(((RealWebSocket$Message)object2).formatOpcode, ((ByteString)object3).size()));
                object.write((ByteString)object3);
                object.close();
                object = this;
                synchronized (object) {
                    this.queueSize -= (long)((ByteString)object3).size();
                }
            } else if (object2 instanceof RealWebSocket$Close) {
                object3 = (RealWebSocket$Close)object2;
                ((WebSocketWriter)object).writeClose(((RealWebSocket$Close)object3).code, ((RealWebSocket$Close)object3).reason);
                if (realWebSocket$Streams != null) {
                    this.listener.onClosed(this, n2, string);
                }
            } else {
                throw new AssertionError();
            }
            return true;
        }
        finally {
            Util.closeQuietly(realWebSocket$Streams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePingFrame() {
        WebSocketWriter webSocketWriter;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            webSocketWriter = this.writer;
        }
        try {
            webSocketWriter.writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException iOException) {
            this.failWebSocket(iOException, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void failWebSocket(Exception exception, Response response) {
        RealWebSocket$Streams realWebSocket$Streams;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            realWebSocket$Streams = this.streams;
            this.streams = null;
            if (this.cancelFuture != null) {
                this.cancelFuture.cancel(false);
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onFailure(this, exception, response);
            return;
        }
        finally {
            Util.closeQuietly(realWebSocket$Streams);
        }
    }

    static /* synthetic */ void access$100(RealWebSocket realWebSocket) {
        realWebSocket.writePingFrame();
    }
}

