/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.platform;

import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.internal.platform.JdkWithJettyBootPlatform$JettyNegoProvider;
import com.zoyi.io.socket.okhttp3.internal.platform.Platform;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.net.ssl.SSLSocket;

class JdkWithJettyBootPlatform
extends Platform {
    private final Method putMethod;
    private final Method getMethod;
    private final Method removeMethod;
    private final Class<?> clientProviderClass;
    private final Class<?> serverProviderClass;

    public JdkWithJettyBootPlatform(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2) {
        this.putMethod = method;
        this.getMethod = method2;
        this.removeMethod = method3;
        this.clientProviderClass = clazz;
        this.serverProviderClass = clazz2;
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) {
        object = JdkWithJettyBootPlatform.alpnProtocolNames(list);
        try {
            object = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JdkWithJettyBootPlatform$JettyNegoProvider((List<String>)object));
            this.putMethod.invoke(null, sSLSocket, object);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    @Override
    public void afterHandshake(SSLSocket sSLSocket) {
        try {
            this.removeMethod.invoke(null, sSLSocket);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError();
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket object) {
        try {
            object = (JdkWithJettyBootPlatform$JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, object));
            if (!((JdkWithJettyBootPlatform$JettyNegoProvider)object).unsupported && ((JdkWithJettyBootPlatform$JettyNegoProvider)object).selected == null) {
                Platform.get().log(4, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", null);
                return null;
            }
            if (((JdkWithJettyBootPlatform$JettyNegoProvider)object).unsupported) {
                return null;
            }
            return ((JdkWithJettyBootPlatform$JettyNegoProvider)object).selected;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError();
        }
    }

    public static Platform buildIfSupported() {
        try {
            Object object = "org.eclipse.jetty.alpn.ALPN";
            GenericDeclaration genericDeclaration = Class.forName("org.eclipse.jetty.alpn.ALPN");
            GenericDeclaration genericDeclaration2 = Class.forName((String)object + "$Provider");
            Class<?> clazz = Class.forName((String)object + "$ClientProvider");
            object = Class.forName((String)object + "$ServerProvider");
            genericDeclaration2 = genericDeclaration.getMethod("put", new Class[]{SSLSocket.class, genericDeclaration2});
            Method method = genericDeclaration.getMethod("get", SSLSocket.class);
            genericDeclaration = genericDeclaration.getMethod("remove", SSLSocket.class);
            return new JdkWithJettyBootPlatform((Method)genericDeclaration2, method, (Method)genericDeclaration, clazz, (Class<?>)object);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }
}

